/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.mobile.api.facade.auth.impl;

import com.openexchange.mobile.api.facade.auth.AuthenticationService;
import com.openexchange.mobile.api.facade.auth.LoginCredentials;
import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.connectors.ConnectorFactory;
import com.openexchange.mobile.api.facade.connectors.ConnectorFactoryFactory;
import com.openexchange.mobile.api.facade.connectors.impl.PnsUnsubscribeConnector;
import com.openexchange.mobile.api.facade.endpoints.requests.LogoutRequestBody;
import com.openexchange.mobile.api.facade.endpoints.requests.PushRequestBody;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@RequiredArgsConstructor
@Slf4j
public class DefaultAuthenticationService implements AuthenticationService {

    private final ConnectorFactoryFactory connectorFactoryFactory;

    @Override
    public SessionData authenticate(LoginCredentials credentials) {
        log.debug("Authenticating");
        ConnectorFactory connectorFactory = connectorFactoryFactory.getConnectorFactory();
        LoginConnector connector = connectorFactory.getLoginConnector(credentials);
        return connector.execute();
    }

    @Override
    public void logout(SessionData sessionData, LogoutRequestBody requestBody) {
        log.debug("Deauthenticating");
        ConnectorFactory connectorFactory = connectorFactoryFactory.getConnectorFactory();
        unsubscribeFromPush(connectorFactory, sessionData, requestBody);
        invalidateSession(connectorFactory, sessionData);
    }

    private void invalidateSession(ConnectorFactory connectorFactory, SessionData sessionData) {
        LogoutConnector connector = connectorFactory.getLogoutConnector(sessionData);
        connector.execute();
    }

    private void unsubscribeFromPush(ConnectorFactory connectorFactory, SessionData sessionData, LogoutRequestBody requestBody) {
        PushRequestBody pushInfo = requestBody.getPushInfo();

        if (pushInfo != null) {
            PnsUnsubscribeConnector connector = connectorFactory.getPnsUnsubscribeConnector(sessionData, pushInfo.getTransport(), pushInfo.getToken());
            connector.execute();
        }
    }

}
