/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.models;

import java.util.List;

import com.openexchange.mobile.api.facade.connectors.responses.mtos.MailMto;
import com.openexchange.mobile.api.facade.connectors.responses.mtos.ThreadMto;
import com.openexchange.mobile.api.facade.connectors.responses.mtos.ThreadReferenceMailMto;
import com.openexchange.mobile.api.facade.connectors.responses.mtos.ThreadReferenceMto;
import com.openexchange.mobile.api.facade.utils.ListUtil;
import com.openexchange.mobile.api.facade.utils.MapFunction;

import lombok.Data;
import lombok.RequiredArgsConstructor;

@Data
@RequiredArgsConstructor
public class MailThread {

    private static final MapFunction<MailMto, Mail> mailMapFunction = new MapFunction<MailMto, Mail>() {
        @Override
        public Mail map(MailMto mailMto) {
            return Mail.createStub(mailMto);
        }
    };

    private static final MapFunction<ThreadReferenceMailMto, Mail> threadReferencesMailMapFunction = new MapFunction<ThreadReferenceMailMto, Mail>() {
        @Override
        public Mail map(ThreadReferenceMailMto mail) {
            return Mail.createStub(mail);
        }
    };

    private final List<Mail> mails;

    private final String rootMailId;

    private final String latestMailId;

    private final Long lastReceivedDate;

    public MailThread(ThreadMto threadMto) {
        rootMailId = threadMto.getId();
        latestMailId = threadMto.getId();
        lastReceivedDate = threadMto.getReceivedDate();
        mails = ListUtil.map(threadMto.getThread(), mailMapFunction);
    }

    public MailThread(ThreadReferenceMto threadMto) {
        rootMailId = threadMto.getRootMailId();
        latestMailId = threadMto.getLatestMailId();
        lastReceivedDate = threadMto.getLatestReceivedDate();
        mails = ListUtil.map(threadMto.getThread(), threadReferencesMailMapFunction);
    }

}
