/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import java.nio.charset.Charset;

import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.connectors.BaseConnector;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;
import com.openexchange.mobile.api.facade.connectors.responses.ThreadedAllResponseMto;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;

public class ThreadedAllStubsConnector extends BaseConnector<ThreadedAllResponseMto> {

    private final String folderId;

    public ThreadedAllStubsConnector(RequestConfiguration configuration, SessionData sessionData, String folderId) {
        super(configuration, sessionData, "mail", ThreadedAllResponseMto.class);
        this.folderId = folderId;
    }

    @Override
    protected HttpUriRequest createRequest() {
        String numMailsPerFolder = sessionData.getConfiguration().getNumMailsPerFolder();
        RequestBuilder builder = RequestBuilder.post(createUrl());
        builder.setCharset(Charset.forName("UTF-8"));
        addSessionData(builder);
        builder.addParameter("action", "threadedAll");
        builder.addParameter("folder", folderId);
        builder.addParameter("sort", "610");
        builder.addParameter("order", "desc");
        builder.addParameter("columns", "600,611,102,610,612");
        builder.addParameter("limit", numMailsPerFolder);
        builder.addParameter("max", numMailsPerFolder);
        builder.addParameter("timezone", "utc");
        return builder.build();
    }

}
