/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.connectors.BaseConnector;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;
import com.openexchange.mobile.api.facade.connectors.responses.ConfigResponseMto;
import com.openexchange.mobile.api.facade.connectors.responses.mtos.ConfigMto;
import com.openexchange.mobile.api.facade.models.Config;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;

public class ConfigConnector extends BaseConnector<ConfigResponseMto> {

    public ConfigConnector(RequestConfiguration configuration, SessionData sessionData) {
        super(configuration, sessionData, "config", ConfigResponseMto.class);
    }

    @Override
    protected HttpUriRequest createRequest() {
        RequestBuilder builder = RequestBuilder.get(createUrl() + "/modules/mail");
        addSessionData(builder);
        return builder.build();
    }

    public static Config map(ConfigResponseMto response) {
        Config config = new Config();
        ConfigMto configMto = response != null ? response.getData() : null;
        if (configMto != null) {
            config.setPurgeOnDeletion(configMto.isPurgeOnDeletion());
            config.setMaxSize(nullIfUnlimited(configMto.getMaxSize()));
            config.setMaxAttachmentSize(nullIfUnlimited(configMto.getMaxAttachmentSize()));
            config.setDeleteDraftOnTransport(configMto.isDeleteDraftOnTransport());
            config.setNamespace(configMto.getNamespace());
        }
        return config;
    }

    private static Long nullIfUnlimited(Long value) {
        return value != null && value.longValue() >= 0 ? value : null;
    }

}
