/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.services;

import com.openexchange.mobile.api.facade.BuildInfo;
import com.openexchange.mobile.api.facade.connectors.ConnectorFactory;
import com.openexchange.mobile.api.facade.connectors.ConnectorFactoryFactory;
import com.openexchange.mobile.api.facade.connectors.impl.VersionConnector;
import com.openexchange.mobile.api.facade.connectors.responses.VersionResponseMto;
import com.openexchange.mobile.api.facade.models.Version;

import lombok.RequiredArgsConstructor;
import lombok.val;

import org.osgi.framework.FrameworkUtil;

@RequiredArgsConstructor
public class VersionService {

    private final ConnectorFactoryFactory connectorFactoryFactory;

    public Version getVersion() {
        val versionString = getBundleVersion();
        val commitHash = getCommitHash();
        val middlewareVersion = getMiddlewareVersion();
        return new Version(versionString, commitHash, middlewareVersion);
    }

    public String getBundleVersion() {
        return FrameworkUtil.getBundle(getClass()).getVersion().toString();
    }

    /*private*/ String getCommitHash() {
        return BuildInfo.gitCommit;
    }

    private String getMiddlewareVersion() {
        ConnectorFactory connectorFactory = connectorFactoryFactory.getConnectorFactory();
        VersionConnector connector = connectorFactory.getVersionConnector();
        VersionResponseMto response = connector.execute();
        return response.getData().getVersion();
    }

}
