/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.endpoints.responses.ctos;

import java.util.List;

import com.openexchange.mobile.api.facade.models.Mail;
import com.openexchange.mobile.api.facade.models.MailThread;
import com.openexchange.mobile.api.facade.utils.ListUtil;
import com.openexchange.mobile.api.facade.utils.MapFunction;

import lombok.Data;

@Data
public class ThreadCto {

    private static final MapFunction<Mail, MailCto> mailMapFunction = new MapFunction<Mail, MailCto>() {
        @Override
        public MailCto map(Mail value) {
            return new MailCto(value);
        }
    };

    private final String rootMailId;

    private final String latestMailId;

    private final Long lastReceivedDate;

    private final List<MailCto> mails;

    public ThreadCto(MailThread thread) {
        rootMailId = thread.getRootMailId();
        latestMailId = thread.getLatestMailId();
        lastReceivedDate = thread.getLastReceivedDate();
        mails = ListUtil.map(thread.getMails(), mailMapFunction);
    }

}
