/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import java.util.ArrayList;
import java.util.List;

import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.connectors.AbstractCommandMto;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;
import com.openexchange.mobile.api.facade.connectors.requests.mtos.SetAndClearFlagsCommandMto;
import com.openexchange.mobile.api.facade.connectors.responses.MailIdResponseMto;
import com.openexchange.mobile.api.facade.models.MailFlags;

public class SetAndClearFlagsConnector extends MultipleConnector<MailIdResponseMto> {

    public SetAndClearFlagsConnector(RequestConfiguration configuration, SessionData sessionData, String folderId, MailFlags flags, List<String> mailIds, boolean value) {
        super(configuration, sessionData, createCommands(folderId, flags, mailIds, value), MailIdResponseMto.class);
    }

    private static List<AbstractCommandMto> createCommands(String folderId, MailFlags flags, List<String> mailIds, boolean value) {
        List<AbstractCommandMto> commands = new ArrayList<>();
        for (String mailId : mailIds) {
            commands.add(new SetAndClearFlagsCommandMto(folderId, mailId, flags.getFlags(), value));
        }
        return commands;
    }

}
