/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors.requests.mtos;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.openexchange.java.Strings;
import com.openexchange.mobile.api.facade.models.MailAccountData;

import lombok.NoArgsConstructor;
import lombok.Value;

@NoArgsConstructor(force = true)
@Value
@JsonInclude(JsonInclude.Include.NON_NULL)
public class MailAccountDataMto {

    // General properties

    Long id;

    @JsonProperty("name")
    String accountName;

    @JsonProperty("personal")
    String personalName;

    String login;

    String password;

    String userName;

    String firstName;

    String lastName;

    @JsonProperty("primary_address")
    String primaryAddress;

    // IMAP/POP3 related properties

    @JsonProperty("addresses")
    String aliases;

    @JsonProperty("mail_protocol")
    String mailProtocol;

    @JsonProperty("mail_server")
    String mailServer;

    @JsonProperty("mail_port")
    Integer mailPort;

    @JsonProperty("mail_secure")
    Boolean mailSecure;

    @JsonProperty("mail_starttls")
    Boolean mailStartTLS;

    @JsonProperty("mail_oauth")
    Integer mailOAuth;

    @JsonProperty("mail_disabled")
    Boolean mailDisabled;

    @JsonProperty("pop3_refresh_rate")
    Integer pop3RefreshRate;

    @JsonProperty("pop3_expunge_on_quit")
    Boolean pop3ExpungeOnQuit;

    @JsonProperty("pop3_delete_write_through")
    Boolean pop3DeleteWriteThrough;

    // Transport related properties

    @JsonProperty("transport_auth")
    String transportAuth;

    @JsonProperty("transport_url")
    String transportUrl;

    @JsonProperty("transport_protocol")
    String transportProtocol;

    @JsonProperty("transport_server")
    String transportServer;

    @JsonProperty("transport_port")
    Integer transportPort;

    @JsonProperty("transport_secure")
    Boolean transportSecure;

    @JsonProperty("transport_starttls")
    Boolean transportStartTLS;

    @JsonProperty("transport_login")
    String transportLogin;

    @JsonProperty("transport_oauth")
    Integer transportOAuth;

    @JsonProperty("transport_disabled")
    Boolean transportDisabled;

    // Folder related properties

    @JsonProperty("spam_handler")
    String spamHandler;

    @JsonProperty("root_folder")
    String rootFolderId;

    @JsonProperty("trash")
    String trashFolder;

    @JsonProperty("sent")
    String sentFolder;

    @JsonProperty("drafts")
    String draftsFolder;

    @JsonProperty("spam")
    String spamFolder;

    @JsonProperty("confirmed_spam")
    String confirmedSpamFolder;

    @JsonProperty("confirmed_ham")
    String confirmedHamFolder;

    @JsonProperty("inbox_fullname")
    String inboxFolderId;

    @JsonProperty("archive_fullname")
    String archiveFolderId;

    @JsonProperty("unified_inbox_enabled")
    Boolean unifiedInboxEnabled;

    public MailAccountDataMto(MailAccountData account) {
        id = account.getId() != null ? Long.parseLong(account.getId()) : null;
        accountName = account.getAccountName();
        personalName = account.getPersonalName();
        login = account.getLogin();
        password = account.getPassword();
        userName = account.getUserName();
        firstName = account.getFirstName();
        lastName = account.getLastName();
        primaryAddress = account.getPrimaryAddress();
        aliases = Strings.join(account.getAliases(), ",");

        mailProtocol = account.getMailProtocol();
        mailServer = account.getMailServer();
        mailPort = account.getMailPort();
        mailStartTLS = account.getMailStartTLS();
        mailOAuth = account.getMailOAuth();
        mailSecure = account.getMailSecure();
        mailDisabled = account.getMailDisabled();
        pop3RefreshRate = account.getPop3RefreshRate();
        pop3ExpungeOnQuit = account.getPop3ExpungeOnQuit();
        pop3DeleteWriteThrough = account.getPop3DeleteWriteThrough();

        transportUrl = null;
        transportProtocol = account.getTransportProtocol();
        transportServer = account.getTransportServer();
        transportPort = account.getTransportPort();
        transportLogin = account.getTransportLogin();
        transportAuth = account.getTransportAuth();
        transportOAuth = account.getTransportOAuth();
        transportSecure = account.getTransportSecure();
        transportStartTLS = account.getTransportStartTLS();
        transportDisabled = account.getTransportDisabled();

        spamHandler = account.getSpamHandler();
        rootFolderId = account.getRootFolderId();
        inboxFolderId = account.getInboxFolderId();
        draftsFolder = account.getDraftsFolder();
        sentFolder = account.getSentFolder();
        trashFolder = account.getTrashFolder();
        spamFolder = account.getSpamFolder();
        confirmedSpamFolder = account.getConfirmedSpamFolder();
        confirmedHamFolder = account.getConfirmedHamFolder();
        archiveFolderId = account.getArchiveFolderId();
        unifiedInboxEnabled = account.getUnifiedInboxEnabled();
    }

}
