/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.endpoints.responses.ctos;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.openexchange.mobile.api.facade.models.Attachment;

import lombok.Data;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AttachmentCto {

    private final String id;

    private final String disposition;

    private final String contentType;

    private final Integer size;

    private final String content;

    private final Boolean truncated;

    private final String filename;

    private final String cid;

    private final String downloadUrl;

    public AttachmentCto(Attachment attachment) {
        this.id = attachment.getId();
        this.disposition = attachment.getDisposition().getValue();
        this.contentType = attachment.getContentType();
        this.size = attachment.getSize();
        this.content = attachment.getContent();
        this.truncated = attachment.isTruncated() ? Boolean.TRUE : null;
        this.filename = attachment.getFilename();
        this.cid = attachment.getCid();
        this.downloadUrl = attachment.getDownloadUrl();
    }

}
