/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import java.util.List;

import com.openexchange.mobile.api.facade.auth.LoginCredentials;
import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.auth.impl.LoginConnector;
import com.openexchange.mobile.api.facade.auth.impl.LogoutConnector;
import com.openexchange.mobile.api.facade.connectors.ConnectorFactory;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;
import com.openexchange.mobile.api.facade.endpoints.requests.AutoconfigData;
import com.openexchange.mobile.api.facade.models.Folder;
import com.openexchange.mobile.api.facade.models.MailAccountData;
import com.openexchange.mobile.api.facade.models.MailFlags;
import com.openexchange.mobile.api.facade.utils.RequestUtil;

public class DefaultConnectorFactory implements ConnectorFactory {

    private final RequestConfiguration configuration;

    public DefaultConnectorFactory() {
        configuration = RequestUtil.createConfiguration();
    }

    @Override
    public GetAccountConnector getAccountConnector(SessionData sessionData, String accountId) {
        return new GetAccountConnector(configuration, sessionData, accountId);
    }

    @Override
    public AccountsConnector getAccountsConnector(SessionData sessionData) {
        return new AccountsConnector(configuration, sessionData);
    }

    @Override
    public AllCapabilitiesConnector getAllCapabilities(SessionData sessionData) {
        return new AllCapabilitiesConnector(configuration, sessionData);
    }

    @Override
    public AllFoldersConnector getAllFoldersConnector(SessionData sessionData, String rootFolderId, String language) {
        return new AllFoldersConnector(configuration, sessionData, rootFolderId, language);
    }

    @Override
    public ClearFolderConnector getClearFolderConnector(SessionData sessionData, String folderId) {
        return new ClearFolderConnector(configuration, sessionData, folderId);
    }

    @Override
    public ConfigConnector getConfigConnector(SessionData sessionData) {
        return new ConfigConnector(configuration, sessionData);
    }

    @Override
    public ContactsConnector getContactsConnector(SessionData sessionData) {
        return new ContactsConnector(configuration, sessionData);
    }

    @Override
    public DeleteAccountConnector getDeleteAccountConnector(SessionData sessionData, String accountId) {
        return new DeleteAccountConnector(configuration, sessionData, accountId);
    }

    @Override
    public CreateFolderConnector getCreateFolderConnector(SessionData sessionData, String parentFolderId, String name) {
        return new CreateFolderConnector(configuration, sessionData, parentFolderId, name);
    }

    @Override
    public UpdateFolderConnector getUpdateFolderConnector(SessionData sessionData, String folderId, String newParentFolderId, String newName) {
        return new UpdateFolderConnector(configuration, sessionData, folderId, newParentFolderId, newName);
    }

    @Override
    public DeleteFolderConnector getDeleteFolderConnector(SessionData sessionData, String folderId) {
        return new DeleteFolderConnector(configuration, sessionData, folderId);
    }

    @Override
    public DeleteMailsConnector getDeleteMailsConnector(SessionData sessionData, String folderId, List<String> mailIds, boolean purge) {
        return new DeleteMailsConnector(configuration, sessionData, folderId, mailIds, purge);
    }

    @Override
    public EnvelopesConnector getEnvelopesConnector(SessionData sessionData, String folderId, List<String> mailIds) {
        return new EnvelopesConnector(configuration, sessionData, folderId, mailIds);
    }

    @Override
    public ExpungeFolderConnector getExpungeFolderConnector(SessionData sessionData, String folderId) {
        return new ExpungeFolderConnector(configuration, sessionData, folderId);
    }

    @Override
    public ExamineMultipleFoldersConnector getExamineFolderConnector(SessionData sessionData, String folderId) {
        return new ExamineMultipleFoldersConnector(configuration, sessionData, folderId);
    }

    @Override
    public ExamineMultipleFoldersConnector getExamineMultipleFoldersConnector(SessionData sessionData, List<Folder> folderIds) {
        return new ExamineMultipleFoldersConnector(configuration, sessionData, folderIds);
    }

    @Override
    public GetMailConnector getGetMailConnector(SessionData sessionData, String folderId, String mailId) {
        return new GetMailConnector(configuration, sessionData, folderId, mailId);
    }

    @Override
    public LoginConnector getLoginConnector(LoginCredentials credentials) {
        return new LoginConnector(configuration, credentials);
    }

    @Override
    public LogoutConnector getLogoutConnector(SessionData sessionData) {
        return new LogoutConnector(configuration, sessionData);
    }

    @Override
    public CreateAccountConnector getCreateAccountConnector(SessionData sessionData, MailAccountData account) {
        return new CreateAccountConnector(configuration, sessionData, account);
    }

    @Override
    public ManifestsConnector getManifestsConnector() {
        return new ManifestsConnector(configuration);
    }

    @Override
    public MoveMailsConnector getMoveMailsConnector(SessionData sessionData, String folderId, List<String> mailIds, String targetFolderId) {
        return new MoveMailsConnector(configuration, sessionData, folderId, mailIds, targetFolderId);
    }

    @Override
    public PnsSubscribeConnector getPnsSubscribeConnector(SessionData sessionData, String transport, String token, List<String> topics) {
        return new PnsSubscribeConnector(configuration, sessionData, transport, token, topics);
    }

    @Override
    public PnsUnsubscribeConnector getPnsUnsubscribeConnector(SessionData sessionData, String transport, String token) {
        return new PnsUnsubscribeConnector(configuration, sessionData, transport, token);
    }

    @Override
    public SetAndClearFlagsConnector getSetAndClearFlagsConnector(SessionData sessionData, String folderId, List<String> mailIds, MailFlags flags, boolean value) {
        return new SetAndClearFlagsConnector(configuration, sessionData, folderId, flags, mailIds, value);
    }

    @Override
    public SetColorsConnector getSetColorsConnector(SessionData sessionData, String folderId, List<String> mailIds, int color) {
        return new SetColorsConnector(configuration, sessionData, folderId, color, mailIds);
    }

    @Override
    public StubsConnector getStubsConnector(SessionData sessionData, String folderId, boolean threaded) {
        return new StubsConnector(configuration, sessionData, folderId, threaded);
    }

    @Override
    public ThreadedAllStubsConnector getThreadedAllStubsConnector(SessionData sessionData, String folderId) {
        return new ThreadedAllStubsConnector(configuration, sessionData, folderId);
    }

    @Override
    public ThreadReferencesConnector getThreadReferencesConnector(SessionData sessionData, String folderId) {
        return new ThreadReferencesConnector(configuration, sessionData, folderId);
    }

    @Override
    public UpdateAccountConnector getUpdateAccountConnector(SessionData sessionData, MailAccountData account) {
        return new UpdateAccountConnector(configuration, sessionData, account);
    }

    @Override
    public UserConnector getUserConnector(SessionData sessionData) {
        return new UserConnector(configuration, sessionData);
    }

    @Override
    public ValidateAccountConnector getValidateAccountConnector(SessionData sessionData, MailAccountData account, boolean forceInsecureConnection, boolean ignoreInvalidTransport) {
        return new ValidateAccountConnector(configuration, sessionData, account, forceInsecureConnection, ignoreInvalidTransport);
    }

    @Override
    public VersionConnector getVersionConnector() {
        return new VersionConnector(configuration);
    }

    @Override
    public GetJsLobConnector getGetJsLobConnector(SessionData sessionData, String name) {
        return new GetJsLobConnector(configuration, sessionData, name);
    }

    @Override
    public AutoconfigureAccountConnector getAutoconfigureAccountConnector(SessionData sessionData, AutoconfigData autoconfigData) {
        return new AutoconfigureAccountConnector(configuration, sessionData, autoconfigData);
    }

}
