/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.utils;

import java.util.ArrayList;
import java.util.List;

import lombok.experimental.UtilityClass;

@UtilityClass
public class ListUtil {

    public boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public <T> List<T> remove(List<T> source, List<T> toRemove) {
        List<T> destination = new ArrayList<>(source);
        destination.removeAll(toRemove);
        return destination;
    }

    public <T, RT> List<RT> map(List<T> values, MapFunction<T, RT> mapFunction) {
        if (values == null) {
            return null;
        }
        List<RT> convertedList = new ArrayList<>(values.size());
        for (T value : values) {
            convertedList.add(mapFunction.map(value));
        }
        return convertedList;
    }

    public <T> List<T> filter(List<T> values, FilterFunction<T> filterFunction) {
        if (values == null) {
            return null;
        }
        List<T> filteredList = new ArrayList<>(values.size());
        for (T value : values) {
            if (filterFunction.filter(value)) {
                filteredList.add(value);
            }
        }
        return filteredList;
    }

}
