/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.endpoints.responses;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.endpoints.responses.ctos.CapabilityCto;
import com.openexchange.mobile.api.facade.models.Capability;
import com.openexchange.mobile.api.facade.utils.ListUtil;
import com.openexchange.mobile.api.facade.utils.MapFunction;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.NonNull;
import lombok.Value;

@Value
@AllArgsConstructor(access = AccessLevel.PRIVATE)
@JsonInclude(Include.NON_EMPTY)
public class AuthenticationResponseBody {

    private static final MapFunction<Capability, CapabilityCto> capabilitiesMapFunction = new MapFunction<Capability, CapabilityCto>() {

        @Override
        public CapabilityCto map(Capability capability) {
            return new CapabilityCto(capability);
        }

    };

    @NonNull
    String session;

    Map<String, String> properties;

    List<CapabilityCto> capabilities;

    public AuthenticationResponseBody(SessionData sessionData) {
        session = sessionData.getSession();
        properties = sessionData.getProperties();
        capabilities = ListUtil.map(sessionData.getCapabilities(), capabilitiesMapFunction);
    }

}
