Name:          open-xchange-mobile-api-facade
BuildArch:     noarch
BuildRequires: java-1.8.0-openjdk-devel
BuildRequires: ant
BuildRequires: open-xchange-admin >= 7.10.6-0, open-xchange-admin < 7.10.7
BuildRequires: open-xchange-grizzly >= 7.10.6-0, open-xchange-grizzly < 7.10.7
BuildRequires: open-xchange-rest >= 7.10.6-0, open-xchange-rest < 7.10.7
Version:       1.14.0
%define        ox_release 1.0
Release:       %{ox_release}_<CI_CNT>.<B_CNT>
Group:         Applications/Productivity
License:       AGPLv3+
BuildRoot:     %{_tmppath}/%{name}-%{version}-build
URL:           http://www.open-xchange.com/
Source:        %{name}_%{version}.orig.tar.bz2
Source2:       open-xchange-mobile-api-facade.service
%define        dropin_dir /etc/systemd/system/open-xchange-mobile-api-facade.service.d
%define        dropin_example limits.conf
Summary:       The Open-Xchange API facade for mobile apps
AutoReqProv:   no
Requires:      open-xchange-admin >= 7.10.6-0, open-xchange-admin < 7.10.7
Requires:      open-xchange-grizzly >= 7.10.6-0, open-xchange-grizzly < 7.10.7
Requires:      open-xchange-rest >= 7.10.6-0, open-xchange-rest < 7.10.7
Requires(pre):    systemd
Requires(post):   systemd
Requires(preun):  systemd
Requires(postun): systemd

%description
Package contains the micro service for running the API facade for mobile apps.

Authors:
--------
    Open-Xchange

%prep

%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -lib build/lib -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build
mkdir -p %{buildroot}/var/log/open-xchange/mobile-api-facade
%__install -D -m 444 %{SOURCE2} %{buildroot}/usr/lib/systemd/system/open-xchange-mobile-api-facade.service

# On Redhat and SuSE start scripts are not automatically added to system start. This is wanted behavior and standard.

%post
if [ ! -f %{dropin_dir}/%{dropin_example} ]
then
  install -D -m 644 %{_defaultdocdir}/%{name}-%{version}/%{dropin_example} %{dropin_dir}/%{dropin_example}
fi

# Trigger a service definition/config reload
systemctl daemon-reload &> /dev/null || :

if [ ${1:-0} -eq 2 ]; then
    # only when updating
    . /opt/open-xchange/lib/oxfunctions.sh

    # prevent bash from expanding, see bug 13316
    GLOBIGNORE='*'

    if ox_scr_todo SCR-676-maf
    then
        # rename all appenders, converters, encoders and policies classes
        logconfig=/opt/open-xchange/mobile-api-facade/etc/logback.xml
        tmp=${logconfig}.tmp
        cp -a --remove-destination $logconfig $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.LogstashSocketAppender/com.openexchange.logback.extensions.appenders.logstash.LogstashAppender/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.encoder/com.openexchange.logback.extensions.appenders.logstash.encoder/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.queueSize/com.openexchange.logback.extensions.appenders.logstash.queueSize/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.alwaysPersistEvents/com.openexchange.logback.extensions.appenders.logstash.alwaysPersistEvents/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.loadFactor/com.openexchange.logback.extensions.appenders.logstash.loadFactor/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.connectionTimeout/com.openexchange.logback.extensions.appenders.logstash.connectionTimeout/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.mbeanEnabled/com.openexchange.logback.extensions.appenders.logstash.mbeanEnabled/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.CustomFieldsAction/com.openexchange.logback.extensions.encoders.CustomFieldAction/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.CustomField/com.openexchange.logback.extensions.encoders.CustomField/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.ExtendedPatternLayoutEncoder/com.openexchange.logback.extensions.encoders.ExtendedPatternLayoutEncoder/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.JSONEncoder/com.openexchange.logback.extensions.encoders.JSONEncoder/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.SyslogPatternLayoutActivator/com.openexchange.logback.extensions.encoders.SyslogPatternLayoutActivator/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.ExtendedReplacingCompositeConverter/com.openexchange.logback.extensions.converters.ExtendedReplacingCompositeConverter/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.LineMDCConverter/com.openexchange.logback.extensions.converters.LineMDCConverter/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.LogSanitisingConverter/com.openexchange.logback.extensions.converters.LogSanitisingConverter/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.ThreadIdConverter/com.openexchange.logback.extensions.converters.ThreadIdConverter/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.FixedWindowRollingPolicy/com.openexchange.logback.extensions.policies.FixedWindowRollingPolicy/g' $tmp
        if [[ $(ox_md5 $tmp) != $(ox_md5 $logconfig) ]]; then
            cat $tmp >$logconfig
        fi
        rm $tmp
        ox_scr_done SCR-676-maf
    fi
fi

%preun

%postun

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/mobile-api-facade/
%dir /opt/open-xchange/mobile-api-facade/bundles/
/opt/open-xchange/mobile-api-facade/bundles/*
%dir %attr(750, open-xchange, root) /opt/open-xchange/mobile-api-facade/osgi/
/opt/open-xchange/mobile-api-facade/osgi/config.ini.template
%dir /opt/open-xchange/mobile-api-facade/osgi/bundle.d/
/opt/open-xchange/mobile-api-facade/osgi/bundle.d/*
%dir /opt/open-xchange/mobile-api-facade/etc/
%config(noreplace) /opt/open-xchange/mobile-api-facade/etc/*
%dir /opt/open-xchange/mobile-api-facade/sbin/
/opt/open-xchange/mobile-api-facade/sbin/open-xchange-mobile-api-facade
%dir %attr(750, open-xchange, root) /var/log/open-xchange/mobile-api-facade
/usr/lib/systemd/system/open-xchange-mobile-api-facade.service
%doc docs/%{dropin_example}

%changelog
* Thu Dec 09 2021 Michael Koch <michael.koch@open-xchange.com>
Release of 1.14.0-rev1
