/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.endpoints.responses.ctos;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.openexchange.mobile.api.facade.endpoints.responses.ctos.serializers.MailFlagsCtoSerializer;
import com.openexchange.mobile.api.facade.models.MailFlags;

import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@JsonSerialize(using = MailFlagsCtoSerializer.class)
public class MailFlagsCto {

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean answered;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean deleted;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean draft;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean flagged;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean forwarded;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean recent;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean spam;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean unread;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean user;

    public MailFlagsCto(MailFlags flags) {
        answered = flags.isAnswered();
        deleted = flags.isDeleted();
        draft = flags.isDraft();
        flagged = flags.isFlagged();
        forwarded = flags.isForwarded();
        recent = flags.isRecent();
        spam = flags.isSpam();
        unread = !flags.isSeen();
        user = flags.isUser();
    }

    public boolean hasFlagsSet() {
        return answered
                || deleted
                || draft
                || flagged
                || forwarded
                || recent
                || spam
                || unread
                || user;
    }

    public MailFlags toMailFlags() {
        return new MailFlags(this);
    }

}
