/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.weakforce.models.serializers;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map.Entry;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.openexchange.mobile.api.facade.weakforce.models.LTAttrs;

public class LTAttrsDeserializer extends JsonDeserializer<LTAttrs> {

    @Override
    public LTAttrs deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        LTAttrs attributes = new LTAttrs();
        JsonNode node = parser.getCodec().readTree(parser);
        if (node == null) {
            throw new JsonParseException(parser, "Could not deserialize LTAttrs object");
        }
        Iterator<Entry<String, JsonNode>> it = node.fields();
        while (it.hasNext()) {
            Entry<String, JsonNode> attribute = it.next();
            String name = attribute.getKey();
            JsonNode valueNode = attribute.getValue();
            Object value;
            if (valueNode instanceof TextNode) {
                value = ((TextNode) valueNode).asText();
            } else if (valueNode instanceof BooleanNode) {
                value = ((BooleanNode) valueNode).asBoolean();
            } else if (valueNode instanceof IntNode) {
                value = ((IntNode) valueNode).asInt();
            } else if (valueNode instanceof DoubleNode) {
                value = ((DoubleNode) valueNode).asDouble();
            } else {
                value = valueNode.toString();
            }
            attributes.add(name, value);
        }
        return attributes;
    }

}
