/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.openexchange.java.Strings;
import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.connectors.BaseConnector;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;
import com.openexchange.mobile.api.facade.connectors.responses.ArrayDataResponseMto;
import com.openexchange.mobile.api.facade.models.Contact;
import com.openexchange.mobile.api.facade.models.DistributionEntry;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;

public class ContactsConnector extends BaseConnector<ArrayDataResponseMto> {

    public ContactsConnector(RequestConfiguration configuration, SessionData sessionData) {
        super(configuration, sessionData, "contacts", ArrayDataResponseMto.class);
    }

    @Override
    protected HttpUriRequest createRequest() {
        RequestBuilder builder = RequestBuilder.get(createUrl());
        addSessionData(builder);
        builder.addParameter("action", "all");
        builder.addParameter("columns", "20,1,500,501,502,505,520,555,556,557,569,602,606,524,592");
        return builder.build();
    }

    public static List<Contact> map(ArrayDataResponseMto responseBody) {
        Object[][] data = responseBody.getData();
        List<Contact> contacts = new ArrayList<>(data.length);
        for (Object[] contactData : data) {
            contacts.add(map(contactData));
        }
        return contacts;
    }

    public static Contact map(Object[] data) {
        String folderId = data[0].toString();
        String contactId = data[1].toString();
        String displayName = nullIfEmpty((String) data[2]);
        String firstName = nullIfEmpty((String) data[3]);
        String lastName = nullIfEmpty((String) data[4]);
        String title = nullIfEmpty((String) data[5]);
        String position = nullIfEmpty((String) data[6]);
        String email1 = nullIfEmpty((String) data[7]);
        String email2 = nullIfEmpty((String) data[8]);
        String email3 = nullIfEmpty((String) data[9]);
        String company = nullIfEmpty((String) data[10]);
        String imageUrl = nullIfEmpty((String) data[12]);
        Boolean isDistributionList = (Boolean) data[11];
        @SuppressWarnings("unchecked")
        List<HashMap<String, Object>> rawDistributionList = (List<HashMap<String, Object>>) data[14];
        List<DistributionEntry> distributionList = null;
        if (isDistributionList != null && isDistributionList && rawDistributionList != null) {
            distributionList = mapDistributionList(rawDistributionList);
        }
        return new Contact(folderId, contactId, displayName, firstName, lastName, title, position, email1, email2, email3, company, imageUrl, distributionList);
    }

    private static List<DistributionEntry> mapDistributionList(List<HashMap<String, Object>> rawDistributionList) {
        List<DistributionEntry> distributionList = new ArrayList<>(rawDistributionList.size());
        for (HashMap<String, Object> rawDistributionEntry : rawDistributionList) {
            String displayName = (String) rawDistributionEntry.get("display_name");
            String email = (String) rawDistributionEntry.get("mail");
            distributionList.add(new DistributionEntry(displayName, email));
        }
        return distributionList;
    }

    private static String nullIfEmpty(String str) {
        return Strings.isEmpty(str) ? null : str;
    }

}
