/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.configuration.clientspecific;

import com.openexchange.mobile.api.facade.utils.UserAgentInfo;
import com.vdurmont.semver4j.Semver;

public abstract class AbstractVersionMatchCriteria implements MatchCriteria {

    private final Semver fromVersion;

    private final Semver upToVersion;

    public AbstractVersionMatchCriteria(VersionRange range) {
        fromVersion = range.getFromVersion();
        upToVersion = range.getUpToVersion();
    }

    protected abstract String getVersion(UserAgentInfo userAgentInfo);

    @Override
    public boolean matches(UserAgentInfo userAgentInfo) {
        String version = getVersion(userAgentInfo);
        if (fromVersion != null && fromVersion.isGreaterThan(version)) {
            return false;
        }
        if (upToVersion != null && upToVersion.isLowerThan(version)) {
            return false;
        }
        return true;
    }

    protected String toRangeString() {
        return "" + fromVersion + "-" + upToVersion;
    }

}
