/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors.responses.mtos;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;

@Data
@AllArgsConstructor
@NoArgsConstructor(force = true, access = AccessLevel.PRIVATE)
public class MailMto {

    @NonNull
    private final String id;

    @JsonProperty("account_name")
    private final String accountName;

    @JsonProperty("account_id")
    private final int accountId;

    private final int flags;

    @JsonProperty("color_label")
    private final int color;

    private final int priority;

    private final int level;

    @NonNull
    @JsonProperty("received_date")
    private final Long receivedDate;

    @JsonProperty("sent_date")
    private final Long sentDate;

    private final List<List<String>> from;

    private final List<List<String>> to;

    private final List<List<String>> cc;

    private final List<List<String>> bcc;

    private final String subject;

    private final Map<String, Object> headers;

    @JsonProperty("content_type")
    private final String contentType;

    private final Long size;

    private final boolean attachment;

    @JsonProperty("real_attachment")
    private final boolean realAttachment;

    private final List<AttachmentMto> attachments;

}
