/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.openexchange.mobile.api.facade.configuration.HostConfiguration;
import com.openexchange.mobile.api.facade.utils.JacksonUtil;
import com.openexchange.mobile.api.facade.utils.RequestUtil;
import com.openexchange.mobile.api.facade.weakforce.models.LoginTupleReport;
import com.openexchange.mobile.api.facade.weakforce.models.ReportResponse;

import lombok.SneakyThrows;

import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;

public class WeakforceReportConnector extends WeakforceConnector<ReportResponse> {

    private final LoginTupleReport requestBody;

    public WeakforceReportConnector(HostConfiguration configuration, LoginTupleReport requestBody) {
        super(configuration, "report", ReportResponse.class);
        this.requestBody = requestBody;
    }

    @Override
    protected HttpUriRequest createRequest() {
        RequestBuilder builder = RequestBuilder.post(createUrl());
        addAuthentication(builder);
        builder.addHeader(RequestUtil.HEADER_CONTENT_TYPE, RequestUtil.CONTENT_TYPE_JSON);
        builder.setEntity(createEntity());
        return builder.build();
    }

    @SneakyThrows
    private HttpEntity createEntity() {
        ObjectMapper mapper = JacksonUtil.getMapper();
        String str = mapper.writeValueAsString(requestBody);
        return new StringEntity(str, "UTF-8");
    }

}
