/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.exceptions.ApiFacadeException;

public abstract class BaseConnector<T extends AbstractResponseMto> extends AbstractConnector<T> {

    private final Class<T> responseBodyType;

    public BaseConnector(RequestConfiguration configuration, String module, Class<T> bodyType) {
        super(configuration, module);
        this.responseBodyType = bodyType;
    }

    public BaseConnector(RequestConfiguration configuration, SessionData sessionData, String module, Class<T> bodyType) {
        super(configuration, sessionData, module);
        this.responseBodyType = bodyType;
    }

    @Override
    protected JavaType getResponseBodyType(ObjectMapper mapper) {
        return mapper.getTypeFactory().constructType(responseBodyType);
    }

    @Override
    protected boolean isError(T responseBody) {
        return responseBody != null && responseBody.isError();
    }

    @Override
    protected ApiFacadeException handleErrors(T responseBody) {
        return ApiFacadeException.fromResponseBody(responseBody);
    }

}
