/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.weakforce;

import com.openexchange.mobile.api.facade.auth.LoginCredentials;
import com.openexchange.mobile.api.facade.configuration.HostConfiguration;
import com.openexchange.mobile.api.facade.connectors.impl.WeakforceAllowConnector;
import com.openexchange.mobile.api.facade.connectors.impl.WeakforceReportConnector;
import com.openexchange.mobile.api.facade.exceptions.ApiFacadeException;
import com.openexchange.mobile.api.facade.utils.WeakforceUtil;
import com.openexchange.mobile.api.facade.weakforce.models.AllowResponse;
import com.openexchange.mobile.api.facade.weakforce.models.LTAttrs;
import com.openexchange.mobile.api.facade.weakforce.models.LoginTupleAllow;
import com.openexchange.mobile.api.facade.weakforce.models.LoginTupleReport;
import com.openexchange.mobile.api.facade.weakforce.models.ReportResponse;

public class WeakforceService {

    public AllowResponse allow(HostConfiguration configuration, LoginCredentials credentials) {
        LoginTupleAllow requestBody = createLoginTupleAllow(configuration, credentials);
        WeakforceAllowConnector connector = new WeakforceAllowConnector(configuration, requestBody);
        return connector.execute();
    }

    /*private*/ LoginTupleAllow createLoginTupleAllow(HostConfiguration configuration, LoginCredentials credentials) {
        String passwordHash = WeakforceUtil.generatePasswordHash(configuration, credentials);
        String deviceId = credentials.getUserAgent();
        String protocol = credentials.getForwardedProto();
        LTAttrs attributes = new LTAttrs();
        return new LoginTupleAllow(credentials.getUsername(), passwordHash, credentials.getRemoteIp(), deviceId, Protocol.HTTP, Protocol.isTls(protocol), attributes);
    }

    public void report(HostConfiguration configuration, LoginCredentials credentials, boolean loginSuccessful, boolean policyReject) {
        LoginTupleReport requestBody = createLoginTupleReport(configuration, credentials, loginSuccessful, policyReject);
        WeakforceReportConnector connector = new WeakforceReportConnector(configuration, requestBody);
        ReportResponse response = connector.execute();
        if (response == null || !"ok".equals(response.getStatus())) {
            throw ApiFacadeException.internalServerError("Failed to connect to weakforce");
        }
    }

    /*private*/ LoginTupleReport createLoginTupleReport(HostConfiguration configuration, LoginCredentials credentials, boolean loginSuccessful, boolean policyReject) {
        String passwordHash = WeakforceUtil.generatePasswordHash(configuration, credentials);
        String deviceId = credentials.getUserAgent();
        String protocol = credentials.getForwardedProto();
        LTAttrs attributes = new LTAttrs();
        return new LoginTupleReport(credentials.getUsername(), passwordHash, credentials.getRemoteIp(), deviceId, Protocol.HTTP, Protocol.isTls(protocol), loginSuccessful, policyReject, attributes);
    }

}
