/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.models;

import com.openexchange.mobile.api.facade.endpoints.responses.ctos.MailFlagsCto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class MailFlags {

    private int flags;

    public MailFlags(MailFlagsCto flags) {
        int value = 0;
        if (flags.isAnswered()) {
            value |= 1;
        }
        if (flags.isDeleted()) {
            value |= 2;
        }
        if (flags.isDraft()) {
            value |= 4;
        }
        if (flags.isFlagged()) {
            value |= 8;
        }
        if (flags.isRecent()) {
            value |= 16;
        }
        if (!flags.isUnread()) {
            value |= 32;
        }
        if (flags.isUser()) {
            value |= 64;
        }
        if (flags.isSpam()) {
            value |= 128;
        }
        if (flags.isForwarded()) {
            value |= 256;
        }
        this.flags = value;
    }

    public boolean isAnswered() {
        return (flags & 1) != 0;
    }

    public void setAnswered(boolean value) {
        flags = value ? flags | 1 : flags & ~1;
    }

    public boolean isDeleted() {
        return (flags & 2) != 0;
    }

    public void setDeleted(boolean value) {
        flags = value ? flags | 2 : flags & ~2;
    }

    public boolean isDraft() {
        return (flags & 4) != 0;
    }

    public void setDraft(boolean value) {
        flags = value ? flags | 4 : flags & ~4;
    }

    public boolean isFlagged() {
        return (flags & 8) != 0;
    }

    public void setFlagged(boolean value) {
        flags = value ? flags | 8 : flags & ~8;
    }

    public boolean isForwarded() {
        return (flags & 256) != 0;
    }

    public void setForwarded(boolean value) {
        flags = value ? flags | 256 : flags & ~256;
    }

    public boolean isRecent() {
        return (flags & 16) != 0;
    }

    public void setRecent(boolean value) {
        flags = value ? flags | 16 : flags & ~16;
    }

    public boolean isSeen() {
        return (flags & 32) != 0;
    }

    public void setSeen(boolean value) {
        flags = value ? flags | 32 : flags & ~32;
    }

    public boolean isSpam() {
        return (flags & 128) != 0;
    }

    public void setSpam(boolean value) {
        flags = value ? flags | 128 : flags & ~128;
    }

    public boolean isUser() {
        return (flags & 64) != 0;
    }

    public void setUser(boolean value) {
        flags = value ? flags | 64 : flags & ~64;
    }

}
