/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.endpoints.responses.ctos.serializers;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.openexchange.mobile.api.facade.endpoints.responses.ctos.MailFlagsCto;

public class MailFlagsCtoSerializer extends JsonSerializer<MailFlagsCto> {

    @Override
    public boolean isEmpty(SerializerProvider provider, MailFlagsCto value) {
        return !value.hasFlagsSet();
    }

    @Override
    public void serialize(MailFlagsCto value, JsonGenerator generator, SerializerProvider provider) throws IOException, JsonProcessingException {
        generator.writeStartObject();
        if (value.isAnswered()) {
            generator.writeBooleanField("answered", true);
        }
        if (value.isDeleted()) {
            generator.writeBooleanField("deleted", true);
        }
        if (value.isDraft()) {
            generator.writeBooleanField("draft", true);
        }
        if (value.isFlagged()) {
            generator.writeBooleanField("flagged", true);
        }
        if (value.isForwarded()) {
            generator.writeBooleanField("forwarded", true);
        }
        if (value.isRecent()) {
            generator.writeBooleanField("recent", true);
        }
        if (value.isSpam()) {
            generator.writeBooleanField("spam", true);
        }
        if (value.isUnread()) {
            generator.writeBooleanField("unread", true);
        }
        if (value.isUser()) {
            generator.writeBooleanField("user", true);
        }
        generator.writeEndObject();
    }

}
