/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.auth;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.openexchange.mobile.api.facade.configuration.HostConfiguration;
import com.openexchange.mobile.api.facade.models.Capability;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;
import lombok.Value;
import lombok.With;
import lombok.experimental.NonFinal;

import org.apache.http.cookie.Cookie;

@Value
@AllArgsConstructor(access = AccessLevel.PRIVATE)
@RequiredArgsConstructor
public class SessionData {

    public static final String PROPERTY_TRACKING_ID = "trackingId";

    public static final String PROPERTY_CONTEXT_ID = "contextId";

    public static final String PROPERTY_USER_ID = "userId";

    @NonNull
    String session;

    @NonNull
    List<Cookie> cookies;

    @With
    @NonFinal
    String userAgent;

    @With
    @NonFinal
    HostConfiguration configuration;

    @With
    @NonFinal
    String host;

    @With
    @NonFinal
    String xHost;

    @With
    @NonFinal
    String forwardedFor;

    @With
    @NonFinal
    String forwardedProto;

    @With
    @NonFinal
    @NonNull
    Map<String, String> properties = new HashMap<>();

    @With
    @NonFinal
    @NonNull
    List<Capability> capabilities = Collections.emptyList();

    public String getProperty(String name) {
        return properties.get(name);
    }

    public void setProperty(String name, String value) {
        properties.put(name, value);
    }

}
