/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.openexchange.java.Strings;
import com.openexchange.mobile.api.facade.connectors.responses.mtos.UserMto;

import lombok.experimental.UtilityClass;

@UtilityClass
public class AccountUtil {

    public String getUserName(String personalName, UserMto userMto) {
        // Prefer personal name from mail account.
        if (Strings.isNotEmpty(personalName)) {
            return personalName;
        }

        // Build name from firstName and lastName of user.
        String userName;
        String firstName = userMto.getFirstName();
        String lastName = userMto.getLastName();
        if (Strings.isNotEmpty(firstName) || Strings.isNotEmpty(lastName)) {
            if (Strings.isEmpty(firstName)) {
                userName = lastName;
            } else if (Strings.isEmpty(lastName)) {
                userName = firstName;
            } else {
                userName = firstName + " " + lastName;
            }
        } else {
            // Fallback to display name.
            userName = userMto.getDisplayName();
        }
        return userName;
    }

    public List<String> getAliases(String primaryAddress, String aliasesStr) {
        if (Strings.isEmpty(aliasesStr)) {
            return null;
        }
        String[] splittedAliases = aliasesStr.split(",");
        for (int index = 0; index < splittedAliases.length; index++) {
            splittedAliases[index] = splittedAliases[index].trim();
        }
        List<String> aliases = new ArrayList<>(Arrays.asList(splittedAliases));
        while (aliases.remove(primaryAddress)) {
            // Nothing to do.
        }
        return aliases.isEmpty() ? null : aliases;
    }

}
