/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import com.openexchange.mobile.api.facade.connectors.BaseConnector;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;
import com.openexchange.mobile.api.facade.connectors.responses.ManifestsResponseMto;
import com.openexchange.mobile.api.facade.connectors.responses.mtos.ManifestsMto;
import com.openexchange.mobile.api.facade.models.Manifest;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;

public class ManifestsConnector extends BaseConnector<ManifestsResponseMto> {

    public ManifestsConnector(RequestConfiguration configuration) {
        super(configuration, null, "apps/manifests", ManifestsResponseMto.class);
    }

    @Override
    protected HttpUriRequest createRequest() {
        RequestBuilder builder = RequestBuilder.get(createUrl());
        builder.addParameter("action", "config");
        return builder.build();
    }

    public static Manifest map(ManifestsResponseMto response) {
        boolean allowsOnlyUsernameForLogin = false;
        if (response != null && response.getData() != null) {
            ManifestsMto data = response.getData();
            allowsOnlyUsernameForLogin = data.isAllowsOnlyUsernameForLogin();
        }
        return new Manifest(allowsOnlyUsernameForLogin);
    }

}
