/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import java.nio.charset.Charset;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.connectors.BaseConnector;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;
import com.openexchange.mobile.api.facade.connectors.requests.mtos.FolderCreateRequestMto;
import com.openexchange.mobile.api.facade.connectors.responses.StringResponseMto;
import com.openexchange.mobile.api.facade.utils.JacksonUtil;

import lombok.SneakyThrows;

import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;

public class CreateFolderConnector extends BaseConnector<StringResponseMto> {

    private final String parentFolderId;

    private final String name;

    public CreateFolderConnector(RequestConfiguration configuration, SessionData sessionData, String parentFolderId, String name) {
        super(configuration, sessionData, "folders", StringResponseMto.class);
        this.parentFolderId = parentFolderId;
        this.name = name;
    }

    @Override
    protected HttpUriRequest createRequest() {
        RequestBuilder builder = RequestBuilder.put(createUrl());
        builder.setCharset(Charset.forName("UTF-8"));
        addSessionData(builder);
        builder.addParameter("action", "new");
        builder.addParameter("folder_id", parentFolderId);
        builder.addParameter("autorename", "false");
        builder.setEntity(createEntity());
        return builder.build();
    }

    @SneakyThrows
    private HttpEntity createEntity() {
        FolderCreateRequestMto folderRequestMto = new FolderCreateRequestMto(name);
        ObjectMapper mapper = JacksonUtil.getMapper();
        String str = mapper.writeValueAsString(folderRequestMto);
        return new StringEntity(str, "UTF-8");
    }

    public static String map(StringResponseMto response) {
        if (response == null) {
            throw new IllegalArgumentException("Invalid response");
        }
        return response.getData();
    }

}
