/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.configuration.clientspecific;

import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.Semver.SemverType;

import lombok.Value;

@Value
public class VersionRange {

    Semver fromVersion;

    Semver upToVersion;

    public VersionRange(String value) {
        int indexDash = value.indexOf('-');
        if (indexDash < 0) {
            fromVersion = new Semver(value, SemverType.LOOSE);
            upToVersion = new Semver(value, SemverType.LOOSE);
        } else if (indexDash == 0) {
            fromVersion = null;
            upToVersion = new Semver(value.substring(1), SemverType.LOOSE);
        } else if (indexDash == value.length() - 1) {
            fromVersion = new Semver(value.substring(0, indexDash), SemverType.LOOSE);
            upToVersion = null;
        } else {
            fromVersion = new Semver(value.substring(0, indexDash), SemverType.LOOSE);
            upToVersion = new Semver(value.substring(indexDash + 1), SemverType.LOOSE);
        }
    }

}
