/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.weakforce.models.serializers;

import java.io.IOException;
import java.util.Map;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.openexchange.mobile.api.facade.weakforce.models.LTAttrs;

public class LTAttrsSerializer extends JsonSerializer<LTAttrs> {

    @Override
    public boolean isEmpty(SerializerProvider provider, LTAttrs value) {
        return value == null || value.isEmpty();
    }

    @Override
    public void serialize(LTAttrs attributes, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        gen.writeStartObject();
        for (Map.Entry<String, Object> entry : attributes.getEntries()) {
            gen.writeFieldName(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof String) {
                gen.writeString((String) value);
            } else if (value instanceof Boolean) {
                gen.writeBoolean(((Boolean) value).booleanValue());
            } else if (value instanceof Integer) {
                gen.writeNumber(((Integer) value).intValue());
            } else if (value instanceof Double) {
                gen.writeNumber(((Double) value).doubleValue());
            } else {
                gen.writeString(value.toString());
            }
        }
        gen.writeEndObject();
    }

}
