/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.utils;

import com.openexchange.mobile.api.facade.models.Attachment;
import com.openexchange.mobile.api.facade.models.Attachment.Disposition;
import com.openexchange.mobile.api.facade.models.Mail;

import lombok.experimental.UtilityClass;

@UtilityClass
public class AttachmentUtil {

    public void initializeDownloadUrls(String folderId, Mail mail) {
        if (mail == null || mail.getParts() == null) {
            return;
        }
        for (Attachment attachment : mail.getParts()) {
            if (Disposition.ATTACHMENT.equals(attachment.getDisposition())
                    || (Disposition.INLINE.equals(attachment.getDisposition()) && attachment.getContent() == null)
                    || attachment.isTruncated()) {
                String downloadUrl = buildDownloadUrl(folderId, mail, attachment);
                attachment.setDownloadUrl(downloadUrl);
            }
        }
    }

    private String buildDownloadUrl(String folderId, Mail mail, Attachment attachment) {
        return String.format("/appsuite/api/mail?action=attachment&folder=%s&id=%s&attachment=%s", folderId, mail.getId(), attachment.getId());
    }

}
