/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.endpoints.responses.ctos;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.openexchange.mobile.api.facade.models.Capability;
import com.openexchange.mobile.api.facade.models.Config;
import com.openexchange.mobile.api.facade.utils.ListUtil;
import com.openexchange.mobile.api.facade.utils.MapFunction;

import lombok.Value;

@Value
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConfigCto {

    private static final MapFunction<Capability, CapabilityCto> capabilitiesMapFunction = new MapFunction<Capability, CapabilityCto>() {

        @Override
        public CapabilityCto map(Capability capability) {
            return new CapabilityCto(capability);
        }

    };

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    boolean purgeOnDeletion;

    @JsonProperty("maxUploadSize")
    Long maxSize;

    @JsonProperty("maxUploadAttachmentSize")
    Long maxAttachmentSize;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    boolean deleteDraftOnTransport;

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    List<CapabilityCto> capabilities;

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    Map<String, String> properties;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    boolean multipleAccountsEnabled;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    String namespace;

    public ConfigCto(Config config) {
        purgeOnDeletion = config.isPurgeOnDeletion();
        maxSize = config.getMaxSize();
        maxAttachmentSize = config.getMaxAttachmentSize();
        deleteDraftOnTransport = config.isDeleteDraftOnTransport();
        capabilities = ListUtil.map(config.getCapabilities(), capabilitiesMapFunction);
        properties = config.getProperties();
        multipleAccountsEnabled = config.isMultipleAccountsEnabled();
        namespace = config.getNamespace();
    }

}
