/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.connectors.BaseConnector;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;
import com.openexchange.mobile.api.facade.connectors.responses.MailAccountResponseMto;
import com.openexchange.mobile.api.facade.endpoints.requests.AutoconfigData;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;

public class AutoconfigureAccountConnector extends BaseConnector<MailAccountResponseMto> {

    private final AutoconfigData autoconfigData;

    public AutoconfigureAccountConnector(RequestConfiguration configuration, SessionData sessionData, AutoconfigData autoconfigData) {
        super(configuration, sessionData, "autoconfig", MailAccountResponseMto.class);
        this.autoconfigData = autoconfigData;
    }

    @Override
    protected HttpUriRequest createRequest() {
        RequestBuilder builder = RequestBuilder.post(createUrl());
        addSessionData(builder);
        builder.addParameter("action", "get");
        builder.addParameter("email", autoconfigData.getMailAddress());
        builder.addParameter("password", autoconfigData.getPassword());
        boolean isForceInsecureConnection = autoconfigData.isForceInsecureConnection();
        if (isForceInsecureConnection) {
            builder.addParameter("force_secure", Boolean.toString(isForceInsecureConnection));
        }
        return builder.build();
    }

}
