package com.openexchange.mobile.api.facade.configuration.clientspecific;

import com.openexchange.mobile.api.facade.utils.UserAgentInfo;
import com.vdurmont.semver4j.Semver;

public abstract class AbstractVersionMatchCriteria implements MatchCriteria {

    private final Semver fromVersion;

    private final Semver upToVersion;

    public AbstractVersionMatchCriteria(VersionRange range) {
        fromVersion = range.getFromVersion();
        upToVersion = range.getUpToVersion();
    }

    protected abstract String getVersion(UserAgentInfo userAgentInfo);

    @Override
    public boolean matches(UserAgentInfo userAgentInfo) {
        String version = getVersion(userAgentInfo);
        if (fromVersion != null && fromVersion.isGreaterThan(version)) {
            return false;
        }
        if (upToVersion != null && upToVersion.isLowerThan(version)) {
            return false;
        }
        return true;
    }

    protected String toRangeString() {
        return "" + fromVersion + "-" + upToVersion;
    }

}
