Name:          open-xchange-mobile-api-facade
BuildArch:     noarch
BuildRequires: java-1.8.0-openjdk-devel
BuildRequires: ant
BuildRequires: open-xchange-admin >= 7.10.4-0, open-xchange-admin < 7.10.5
BuildRequires: open-xchange-grizzly >= 7.10.4-0, open-xchange-grizzly < 7.10.5
BuildRequires: open-xchange-rest >= 7.10.4-0, open-xchange-rest < 7.10.5
Version:       1.10.0
%define        ox_release 1.0
Release:       %{ox_release}_<CI_CNT>.<B_CNT>
Group:         Applications/Productivity
License:       GPL-2.0
BuildRoot:     %{_tmppath}/%{name}-%{version}-build
URL:           http://www.open-xchange.com/
Source:        %{name}_%{version}.orig.tar.bz2
Source2:       open-xchange-mobile-api-facade.service
%define        dropin_dir /etc/systemd/system/open-xchange-mobile-api-facade.service.d
%define        dropin_example limits.conf
Summary:       The Open-Xchange API facade for mobile apps
AutoReqProv:   no
Requires:      open-xchange-admin >= 7.10.4-0, open-xchange-admin < 7.10.5
Requires:      open-xchange-grizzly >= 7.10.4-0, open-xchange-grizzly < 7.10.5
Requires:      open-xchange-rest >= 7.10.4-0, open-xchange-rest < 7.10.5
Requires(pre):    systemd
Requires(post):   systemd
Requires(preun):  systemd
Requires(postun): systemd

%description
Package contains the micro service for running the API facade for mobile apps.

Authors:
--------
    Open-Xchange

%prep

%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -lib build/lib -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build
mkdir -p %{buildroot}/var/log/open-xchange/mobile-api-facade
%__install -D -m 444 %{SOURCE2} %{buildroot}/usr/lib/systemd/system/open-xchange-mobile-api-facade.service

# On Redhat and SuSE start scripts are not automatically added to system start. This is wanted behavior and standard.

%post
if [ ! -f %{dropin_dir}/%{dropin_example} ]
then
  install -D -m 644 %{_defaultdocdir}/%{name}-%{version}/%{dropin_example} %{dropin_dir}/%{dropin_example}
fi

# Trigger a service definition/config reload
systemctl daemon-reload &> /dev/null || :

%preun

%postun

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/mobile-api-facade/
%dir /opt/open-xchange/mobile-api-facade/bundles/
/opt/open-xchange/mobile-api-facade/bundles/*
%dir %attr(750, open-xchange, root) /opt/open-xchange/mobile-api-facade/osgi/
/opt/open-xchange/mobile-api-facade/osgi/config.ini.template
%dir /opt/open-xchange/mobile-api-facade/osgi/bundle.d/
/opt/open-xchange/mobile-api-facade/osgi/bundle.d/*
%dir /opt/open-xchange/mobile-api-facade/etc/
%config(noreplace) /opt/open-xchange/mobile-api-facade/etc/*
%dir /opt/open-xchange/mobile-api-facade/sbin/
/opt/open-xchange/mobile-api-facade/sbin/open-xchange-mobile-api-facade
%dir %attr(750, open-xchange, root) /var/log/open-xchange/mobile-api-facade
/usr/lib/systemd/system/open-xchange-mobile-api-facade.service
%doc docs/%{dropin_example}

%changelog
* Thu Aug 06 2020 Michael Koch <michael.koch@open-xchange.com>
Release of 1.10.0-1
