/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.connectors.BaseConnector;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;
import com.openexchange.mobile.api.facade.connectors.responses.ArrayDataResponseMto;
import com.openexchange.mobile.api.facade.models.Contact;
import com.openexchange.mobile.api.facade.models.DistributionEntry;
import com.openexchange.mobile.api.facade.utils.StringUtils;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;

public class ContactsConnector extends BaseConnector<ArrayDataResponseMto> {

    public ContactsConnector(RequestConfiguration configuration, SessionData sessionData) {
        super(configuration, sessionData, "contacts", ArrayDataResponseMto.class);
    }

    @Override
    protected HttpUriRequest createRequest() {
        RequestBuilder builder = RequestBuilder.get(createUrl());
        addSessionData(builder);
        builder.addParameter("action", "all");
        builder.addParameter("columns", "20,1,500,501,502,505,520,555,556,557,569,602,606,524,592");
        return builder.build();
    }

    public static List<Contact> map(ArrayDataResponseMto responseBody) {
        Object[][] data = responseBody.getData();
        List<Contact> contacts = new ArrayList<>(data.length);
        for (Object[] contactData : data) {
            contacts.add(map(contactData));
        }
        return contacts;
    }

    public static Contact map(Object[] data) {
        String folderId = data[0].toString();
        String contactId = data[1].toString();
        String displayName = nullIfEmpty((String) data[2]);
        String firstName = nullIfEmpty((String) data[3]);
        String lastName = nullIfEmpty((String) data[4]);
        String title = nullIfEmpty((String) data[5]);
        String position = nullIfEmpty((String) data[6]);
        String email1 = nullIfEmpty((String) data[7]);
        String email2 = nullIfEmpty((String) data[8]);
        String email3 = nullIfEmpty((String) data[9]);
        String company = nullIfEmpty((String) data[10]);
        String imageUrl = nullIfEmpty((String) data[12]);
        Boolean isDistributionList = (Boolean) data[11];
        @SuppressWarnings("unchecked")
        List<HashMap<String, Object>> rawDistributionList = (List<HashMap<String, Object>>) data[14];
        List<DistributionEntry> distributionList = null;
        if (isDistributionList != null && isDistributionList && rawDistributionList != null) {
            distributionList = mapDistributionList(rawDistributionList);
        }
        return new Contact(folderId, contactId, displayName, firstName, lastName, title, position, email1, email2, email3, company, imageUrl, distributionList);
    }

    private static List<DistributionEntry> mapDistributionList(List<HashMap<String, Object>> rawDistributionList) {
        List<DistributionEntry> distributionList = new ArrayList<>(rawDistributionList.size());
        for (HashMap<String, Object> rawDistributionEntry : rawDistributionList) {
            String displayName = (String) rawDistributionEntry.get("display_name");
            String email = (String) rawDistributionEntry.get("mail");
            distributionList.add(new DistributionEntry(displayName, email));
        }
        return distributionList;
    }

    private static String nullIfEmpty(String str) {
        return StringUtils.isEmpty(str) ? null : str;
    }

}
