/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.mobile.api.facade.connectors;

import java.util.List;

import com.openexchange.mobile.api.facade.auth.LoginCredentials;
import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.auth.impl.LoginConnector;
import com.openexchange.mobile.api.facade.auth.impl.LogoutConnector;
import com.openexchange.mobile.api.facade.connectors.impl.AccountsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.AllFoldersConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ClearFolderConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ConfigConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ContactsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.CreateFolderConnector;
import com.openexchange.mobile.api.facade.connectors.impl.DeleteFolderConnector;
import com.openexchange.mobile.api.facade.connectors.impl.DeleteMailsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.EnvelopesConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ExamineMultipleFoldersConnector;
import com.openexchange.mobile.api.facade.connectors.impl.GetJsLobConnector;
import com.openexchange.mobile.api.facade.connectors.impl.GetMailConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ManifestsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.MoveMailsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.PnsSubscribeConnector;
import com.openexchange.mobile.api.facade.connectors.impl.PnsUnsubscribeConnector;
import com.openexchange.mobile.api.facade.connectors.impl.SetAndClearFlagsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.SetColorsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.StubsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ThreadReferencesConnector;
import com.openexchange.mobile.api.facade.connectors.impl.ThreadedAllStubsConnector;
import com.openexchange.mobile.api.facade.connectors.impl.UserConnector;
import com.openexchange.mobile.api.facade.connectors.impl.VersionConnector;
import com.openexchange.mobile.api.facade.models.Folder;
import com.openexchange.mobile.api.facade.models.MailFlags;

public interface ConnectorFactory {

    AccountsConnector getAccountsConnector(SessionData sessionData);

    AllFoldersConnector getAllFoldersConnector(SessionData sessionData, String rootFolderId, String language);

    ClearFolderConnector getClearFolderConnector(SessionData sessionData, String folderId);

    ConfigConnector getConfigConnector(SessionData sessionData);

    ContactsConnector getContactsConnector(SessionData sessionData);

    CreateFolderConnector getCreateFolderConnector(SessionData sessionData, String parentFolderId, String name);

    DeleteFolderConnector getDeleteFolderConnector(SessionData sessionData, String folderId);

    DeleteMailsConnector getDeleteMailsConnector(SessionData sessionData, String folderId, List<String> mailIds, boolean purge);

    EnvelopesConnector getEnvelopesConnector(SessionData sessionData, String folderId, List<String> mailIds);

    ExamineMultipleFoldersConnector getExamineFolderConnector(SessionData sessionData, String folderId);

    ExamineMultipleFoldersConnector getExamineMultipleFoldersConnector(SessionData sessionData, List<Folder> folderIds);

    GetJsLobConnector getGetJsLobConnector(SessionData sessionData, String name);

    GetMailConnector getGetMailConnector(SessionData sessionData, String folderId, String mailId);

    LoginConnector getLoginConnector(LoginCredentials credentials);

    LogoutConnector getLogoutConnector(SessionData sessionData);

    ManifestsConnector getManifestsConnector();

    MoveMailsConnector getMoveMailsConnector(SessionData sessionData, String folderId, List<String> mailIds, String targetFolderId);

    PnsSubscribeConnector getPnsSubscribeConnector(SessionData sessionData, String transport, String token, List<String> tokens);

    PnsUnsubscribeConnector getPnsUnsubscribeConnector(SessionData sessionData, String transport, String token);

    SetAndClearFlagsConnector getSetAndClearFlagsConnector(SessionData sessionData, String folderId, List<String> mailIds, MailFlags flags, boolean value);

    SetColorsConnector getSetColorsConnector(SessionData sessionData, String folderId, List<String> mailIds, int color);

    StubsConnector getStubsConnector(SessionData sessionData, String folderId, boolean threaded);

    ThreadedAllStubsConnector getThreadedAllStubsConnector(SessionData sessionData, String folderId);

    ThreadReferencesConnector getThreadReferencesConnector(SessionData sessionData, String folderId);

    UserConnector getUserConnector(SessionData sessionData);

    VersionConnector getVersionConnector();

}
