/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.mobile.api.facade.models;

import com.openexchange.mobile.api.facade.endpoints.responses.ctos.MailFlagsCto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class MailFlags {

    private int flags;

    public MailFlags(MailFlagsCto flags) {
        int value = 0;
        if (flags.isAnswered()) {
            value |= 1;
        }
        if (flags.isDeleted()) {
            value |= 2;
        }
        if (flags.isDraft()) {
            value |= 4;
        }
        if (flags.isFlagged()) {
            value |= 8;
        }
        if (flags.isRecent()) {
            value |= 16;
        }
        if (!flags.isUnread()) {
            value |= 32;
        }
        if (flags.isUser()) {
            value |= 64;
        }
        if (flags.isSpam()) {
            value |= 128;
        }
        if (flags.isForwarded()) {
            value |= 256;
        }
        this.flags = value;
    }

    public boolean isAnswered() {
        return (flags & 1) != 0;
    }

    public void setAnswered(boolean value) {
        flags = value ? flags | 1 : flags & ~1;
    }

    public boolean isDeleted() {
        return (flags & 2) != 0;
    }

    public void setDeleted(boolean value) {
        flags = value ? flags | 2 : flags & ~2;
    }

    public boolean isDraft() {
        return (flags & 4) != 0;
    }

    public void setDraft(boolean value) {
        flags = value ? flags | 4 : flags & ~4;
    }

    public boolean isFlagged() {
        return (flags & 8) != 0;
    }

    public void setFlagged(boolean value) {
        flags = value ? flags | 8 : flags & ~8;
    }

    public boolean isForwarded() {
        return (flags & 256) != 0;
    }

    public void setForwarded(boolean value) {
        flags = value ? flags | 256 : flags & ~256;
    }

    public boolean isRecent() {
        return (flags & 16) != 0;
    }

    public void setRecent(boolean value) {
        flags = value ? flags | 16 : flags & ~16;
    }

    public boolean isSeen() {
        return (flags & 32) != 0;
    }

    public void setSeen(boolean value) {
        flags = value ? flags | 32 : flags & ~32;
    }

    public boolean isSpam() {
        return (flags & 128) != 0;
    }

    public void setSpam(boolean value) {
        flags = value ? flags | 128 : flags & ~128;
    }

    public boolean isUser() {
        return (flags & 64) != 0;
    }

    public void setUser(boolean value) {
        flags = value ? flags | 64 : flags & ~64;
    }

}
