/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.mobile.api.facade.endpoints.responses.ctos;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.openexchange.mobile.api.facade.endpoints.responses.ctos.serializers.MailFlagsCtoSerializer;
import com.openexchange.mobile.api.facade.models.MailFlags;

import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@JsonSerialize(using = MailFlagsCtoSerializer.class)
public class MailFlagsCto {

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean answered;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean deleted;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean draft;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean flagged;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean forwarded;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean recent;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean spam;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean unread;

    @JsonInclude(JsonInclude.Include.NON_DEFAULT)
    private boolean user;

    public MailFlagsCto(MailFlags flags) {
        answered = flags.isAnswered();
        deleted = flags.isDeleted();
        draft = flags.isDraft();
        flagged = flags.isFlagged();
        forwarded = flags.isForwarded();
        recent = flags.isRecent();
        spam = flags.isSpam();
        unread = !flags.isSeen();
        user = flags.isUser();
    }

    public boolean hasFlagsSet() {
        return answered
                || deleted
                || draft
                || flagged
                || forwarded
                || recent
                || spam
                || unread
                || user;
    }

    public MailFlags toMailFlags() {
        return new MailFlags(this);
    }

}
