/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import com.openexchange.ant.data.AbstractModule;
import com.openexchange.ant.data.BinDirModule;
import com.openexchange.ant.data.DirModule;
import com.openexchange.ant.data.JarModule;

/**
 * Contains convenience methods.
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public final class Tools {

    private Tools() {
        super();
    }

    public static String readFile(File projectFile) {
        BufferedReader br = null;
        StringBuilder retval = new StringBuilder();
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(projectFile), "UTF-8"));
            final char[] buf = new char[512];
            int length = 0;
            while ((length = br.read(buf)) != -1) {
                retval.append(buf, 0, length);
            }
        } catch (IOException e) {
            throw new BuildException(e.getMessage(), e);
        } finally {
            if (null != br) {
                try {
                    br.close();
                } catch (IOException e) {
                    throw new BuildException(e.getMessage(), e);
                }
            }
        }
        return retval.toString();
    }

    public static Properties readProperties(File propertiesFile) {
        Properties retval = new Properties();
        InputStreamReader isr;
        try {
            isr = new InputStreamReader(new FileInputStream(propertiesFile), "UTF-8");
        } catch (IOException e) {
            throw new BuildException(e.getMessage(), e);
        }
        try {
            retval.load(isr);
        } catch (IOException e) {
            throw new BuildException(e.getMessage(), e);
        } finally {
            try {
                isr.close();
            } catch (IOException e) {
                throw new BuildException(e.getMessage(), e);
            }
        }
        return retval;
    }

    public static List<AbstractModule> readClasspathModules(Project project, Path classpath) {
        final String[] classpathFiles = classpath.list();
        final List<AbstractModule> retval = new ArrayList<AbstractModule>(classpathFiles.length);
        for (final String classpathFilename : classpathFiles) {
            final File classpathFile = new File(classpathFilename);
            if (classpathFile.isFile()) {
                retval.add(new JarModule(classpathFile));
            } else {
                DirModule classpathModule = new BinDirModule(classpathFile);
                classpathModule.readLocalFiles(project);
                retval.add(classpathModule);
            }
        }
        return retval;
    }

    public static Map<String, AbstractModule> calculateModulesByName(final List<AbstractModule> allModules) {
        final Map<String, AbstractModule> modulesByName;
        modulesByName = new HashMap<String, AbstractModule>();
        for (final AbstractModule module : allModules) {
            modulesByName.put(module.getName(), module);
        }
        return modulesByName;
    }
}
