/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.fileitem.impl;

import java.io.Serializable;

/**
 * {@link FileStoreData}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 * @since v7.10.0
 */
public class FileStoreData implements Serializable {

    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = 1181641698407844928L;

    /**
     * Initializes a new {@link FileStoreData}.
     */
    public FileStoreData(final int fileStoreNumber, final String fileStoreId) {
        super();

        m_fileStoreNumber = fileStoreNumber;
        m_fileStoreId = fileStoreId;
    }

    @Override
    public String toString() {
        return new StringBuilder(256).
            append("FileStoreData").
            append(" [").
            append("fileStoreNumber: ").append(m_fileStoreNumber).
            append(" , fileStoreId: ").append(m_fileStoreId).
            append(']').toString();
    }

    /**
     * @return
     */
    boolean isValid() {
        return (FileItemUtils.isValid(m_fileStoreId) && (m_fileStoreNumber > 0));
    }

    /**
     * @return
     */
    boolean isInvalid() {
        return (FileItemUtils.isInvalid(m_fileStoreId) || (m_fileStoreNumber < 1));
    }

    /**
     * @return
     */
    int getFileStoreNumber() {
        return m_fileStoreNumber;
    }

    /**
     * @return
     */
    String getFileStoreId() {
        return m_fileStoreId;
    }

    // - Members ---------------------------------------------------------------

    private int m_fileStoreNumber = -1;

    private String m_fileStoreId = null;
}
