Name:          open-xchange-imageconverter-server
BuildArch:     noarch
BuildRequires: java-1.8.0-openjdk-devel
BuildRequires: ant
BuildRequires: open-xchange-core >= 7.10.5
BuildRequires: open-xchange-admin-soap >= 7.10.5
BuildRequires: open-xchange-authorization-standard >= 7.10.5
BuildRequires: open-xchange-file-distribution >= 7.10.5
BuildRequires: open-xchange-filestore-s3 >= 7.10.5
BuildRequires: open-xchange-filestore-sproxyd >= 7.10.5
BuildRequires: open-xchange-grizzly >= 7.10.5
BuildRequires: open-xchange-oauth >= 7.10.5
BuildRequires: open-xchange-oauth-provider >= 7.10.5
BuildRequires: open-xchange-rest >= 7.10.5
BuildRequires: open-xchange-sessionstorage-hazelcast >= 7.10.5
Version:       7.10.5
%define        ox_release 10.0
Release:       %{ox_release}_<CI_CNT>.<B_CNT>
Group:         Applications/Productivity
License:       AGPLv3+
BuildRoot:     %{_tmppath}/%{name}-%{version}-build
URL:           http://www.open-xchange.com/
Source:        %{name}_%{version}.orig.tar.bz2
Source2:       open-xchange-imageconverter-server.service
%define        dropin_dir /etc/systemd/system/open-xchange-imageconverter-server.service.d
%define        dropin_example limits.conf
Summary:       The Open-Xchange webservice for image conversion
AutoReqProv:   no
Requires:      gawk
Requires:      curl
Requires:      sed
Requires:      open-xchange-core >= 7.10.5
Requires:      open-xchange-admin-soap >= 7.10.5
Requires:      open-xchange-file-distribution >= 7.10.5
Requires:      open-xchange-filestore-s3 >= 7.10.5
Requires:      open-xchange-filestore-sproxyd >= 7.10.5
Requires:      open-xchange-grizzly >= 7.10.5
Requires:      open-xchange-rest >= 7.10.5
Provides:      open-xchange-imageconverter-server = %{version}
Requires(pre):    systemd
Requires(post):   systemd
Requires(preun):  systemd
Requires(postun): systemd

%description
This package contains the backend components for the ImageConverter web service

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -lib build/lib -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build
mkdir -p %{buildroot}/var/log/open-xchange/imageconverter
mkdir -p %{buildroot}/var/spool/open-xchange/fileitem
mkdir -p %{buildroot}/var/spool/open-xchange/imageconverter
%__install -D -m 444 %{SOURCE2} %{buildroot}/usr/lib/systemd/system/open-xchange-imageconverter-server.service

# On Redhat and SuSE start scripts are not automatically added to system start. This is wanted behavior and standard.

%post
if [ ! -f %{dropin_dir}/%{dropin_example} ]
then
  install -D -m 644 %{_defaultdocdir}/%{name}-%{version}/%{dropin_example} %{dropin_dir}/%{dropin_example}
fi

drop_in=%{dropin_dir}/%{dropin_example}
if [ -f ${drop_in} ] && grep -q "^#LimitNOFILE=16384$" ${drop_in}
then
  sed -i 's/^#LimitNOFILE=16384$/#LimitNOFILE=65536/' ${drop_in}
fi

drop_in=%{dropin_dir}/%{dropin_example}
if [ -f ${drop_in} ] && ! grep -q LimitNPROC ${drop_in}
then
  sed -i '/^\[Service\]$/a #LimitNPROC=65536' ${drop_in}
fi

# Trigger a service definition/config reload
systemctl daemon-reload &> /dev/null || :

if [ ${1:-0} -eq 2 ]; then 
    # only when updating

    . /opt/open-xchange/lib/oxfunctions.sh

    # prevent bash from expanding, see bug 13316
    GLOBIGNORE='*'

    # SCR-438 & SCR-564
    SCR=SCR-438
    ox_scr_todo ${SCR} && {
      pfile=/opt/open-xchange/imageconverter/etc/imageconverter.properties
      ox_add_property com.openexchange.imageconverter.convertTimeoutMillis 20000 ${pfile}
      ox_scr_done ${SCR}
    }

    SCR=SCR-439
    ox_scr_todo ${SCR} && {
      pfile=/opt/open-xchange/imageconverter/etc/imageconverter.properties
      ox_add_property com.openexchange.imageconverter.errorPath "" ${pfile}
      ox_scr_done ${SCR}
    }

    SCR=SCR-458
    ox_scr_todo ${SCR} && {
      pfile=/opt/open-xchange/imageconverter/etc/imageconverter.properties
      pkey=com.openexchange.imageconverter.targetFormats
      new_val_part=auto:1920x1080~cover
      curr_formats=$(ox_read_property ${pkey} ${pfile})
      if [[ ! ${curr_formats} =~ ${new_val_part} ]]
      then
        new_val="${curr_formats}, ${new_val_part}"
        ox_set_property ${pkey} "${new_val}" ${pfile}
      fi
      ox_scr_done ${SCR}
    }

    SCR=SCR-476
    ox_scr_todo ${SCR} && {
      pfile=/opt/open-xchange/imageconverter/etc/overwrite.properties
      pkey=com.openexchange.hazelcast.enabled
      new_val=false
      ox_add_property ${pkey} "${new_val}" ${pfile}
      ox_scr_done ${SCR}
    }

    if ox_scr_todo SCR-486
    then
      pfile=/opt/open-xchange/imageconverter/etc/fileitem.properties
      keys=( com.openexchange.fileitem.readProperty.15 com.openexchange.fileitem.readProperty.16 com.openexchange.fileitem.readProperty.17 com.openexchange.fileitem.readProperty.18 com.openexchange.fileitem.readProperty.19 com.openexchange.fileitem.readProperty.20 com.openexchange.fileitem.readProperty.21 com.openexchange.fileitem.readProperty.22 com.openexchange.fileitem.readProperty.23 com.openexchange.fileitem.writeProperty.15 com.openexchange.fileitem.writeProperty.16 com.openexchange.fileitem.writeProperty.17 com.openexchange.fileitem.writeProperty.18 com.openexchange.fileitem.writeProperty.19 com.openexchange.fileitem.writeProperty.20 com.openexchange.fileitem.writeProperty.21 com.openexchange.fileitem.writeProperty.22 com.openexchange.fileitem.writeProperty.23 )
      values=( "requireSSL=false" "verifyServerCertificate=false" "enabledTLSProtocols=false" "clientCertificateKeyStoreUrl=" "clientCertificateKeyStorePassword=" "clientCertificateKeyStoreType=" "trustCertificateKeyStoreUrl=" "trustCertificateKeyStorePassword=" "trustCertificateKeyStoreType=" "requireSSL=false" "verifyServerCertificate=false" "enabledTLSProtocols=false" "clientCertificateKeyStoreUrl=" "clientCertificateKeyStorePassword=" "clientCertificateKeyStoreType=" "trustCertificateKeyStoreUrl=" "trustCertificateKeyStorePassword=" "trustCertificateKeyStoreType=" )
      for I in $(seq 0 $(expr ${#keys[@]} - 1))
      do
        ox_add_property ${keys[$I]} "${values[$I]}" ${pfile}
      done
      ox_scr_done SCR-486
    fi

    if ox_scr_todo SCR-564
    then
      pfile=/opt/open-xchange/imageconverter/etc/imageconverter.properties
      pkey=com.openexchange.imageconverter.convertTimeoutMillis
      value=$(ox_read_property ${pkey} ${pfile})
      if [ "15000" = "${value}" ]
      then
        ox_set_property ${pkey} 20000 ${pfile}
      fi
      ox_scr_done SCR-564
    fi

    if ox_scr_todo SCR-676-ic
    then
        # rename all appenders, converters, encoders and policies classes
        logconfig=/opt/open-xchange/imageconverter/etc/logback.xml
        tmp=${logconfig}.tmp
        cp -a --remove-destination $logconfig $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.LogstashSocketAppender/com.openexchange.logback.extensions.appenders.logstash.LogstashAppender/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.encoder/com.openexchange.logback.extensions.appenders.logstash.encoder/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.queueSize/com.openexchange.logback.extensions.appenders.logstash.queueSize/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.alwaysPersistEvents/com.openexchange.logback.extensions.appenders.logstash.alwaysPersistEvents/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.loadFactor/com.openexchange.logback.extensions.appenders.logstash.loadFactor/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.connectionTimeout/com.openexchange.logback.extensions.appenders.logstash.connectionTimeout/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.mbeanEnabled/com.openexchange.logback.extensions.appenders.logstash.mbeanEnabled/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.CustomFieldsAction/com.openexchange.logback.extensions.encoders.CustomFieldAction/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.CustomField/com.openexchange.logback.extensions.encoders.CustomField/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.ExtendedPatternLayoutEncoder/com.openexchange.logback.extensions.encoders.ExtendedPatternLayoutEncoder/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.JSONEncoder/com.openexchange.logback.extensions.encoders.JSONEncoder/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.SyslogPatternLayoutActivator/com.openexchange.logback.extensions.encoders.SyslogPatternLayoutActivator/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.ExtendedReplacingCompositeConverter/com.openexchange.logback.extensions.converters.ExtendedReplacingCompositeConverter/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.LineMDCConverter/com.openexchange.logback.extensions.converters.LineMDCConverter/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.LogSanitisingConverter/com.openexchange.logback.extensions.converters.LogSanitisingConverter/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.ThreadIdConverter/com.openexchange.logback.extensions.converters.ThreadIdConverter/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.FixedWindowRollingPolicy/com.openexchange.logback.extensions.policies.FixedWindowRollingPolicy/g' $tmp
        if [[ $(ox_md5 $tmp) != $(ox_md5 $logconfig) ]]; then
            cat $tmp >$logconfig
        fi
        rm $tmp
        ox_scr_done SCR-676-ic
    fi

    if ox_scr_todo SCR-732
    then
      pfile=/opt/open-xchange/imageconverter/etc/fileitem.properties
      pkey_read=com.openexchange.fileitem.readProperty.17
      pkey_write=com.openexchange.fileitem.writeProperty.17
      old_val=enabledTLSProtocols=false
      new_val=enabledTLSProtocols=TLSv1,TLSv1.1,TLSv1.2
      value=$(ox_read_property ${pkey_read} ${pfile})
      if [ "${old_val}" = "${value}" ]
      then
        ox_set_property ${pkey_read} ${new_val} ${pfile}
      fi
      value=$(ox_read_property ${pkey_write} ${pfile})
      if [ "${old_val}" = "${value}" ]
      then
        ox_set_property ${pkey_write} ${new_val} ${pfile}
      fi
      ox_scr_done SCR-732
    fi

fi

%preun

%postun

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/imageconverter
%dir /opt/open-xchange/imageconverter/bundles/
/opt/open-xchange/imageconverter/bundles/*
%dir %attr(750, open-xchange, root) /opt/open-xchange/imageconverter/osgi/
/opt/open-xchange/imageconverter/osgi/config.ini.template
%dir /opt/open-xchange/imageconverter/osgi/bundle.d/
/opt/open-xchange/imageconverter/osgi/bundle.d/*
%dir /opt/open-xchange/imageconverter/etc/
%config(noreplace) /opt/open-xchange/imageconverter/etc/fileitem.properties
%config(noreplace) /opt/open-xchange/imageconverter/etc/imageconverter.properties
%config(noreplace) /opt/open-xchange/imageconverter/etc/logback.xml
%config(noreplace) /opt/open-xchange/imageconverter/etc/overwrite.properties
%config(noreplace) /opt/open-xchange/imageconverter/etc/process-conf.sh
%dir /opt/open-xchange/imageconverter/etc/security
/opt/open-xchange/imageconverter/etc/security/imageconverter.list
%dir /opt/open-xchange/imageconverter/etc/magick
/opt/open-xchange/imageconverter/etc/magick/policy.xml
%dir %attr(755, open-xchange, root) /opt/open-xchange/imageconverter/bin/
%attr(0755,open-xchange,root) /opt/open-xchange/imageconverter/bin/imageconverter-kill-orphans
%dir %attr(750, open-xchange, root) /opt/open-xchange/imageconverter/lib/
%attr(0755,root,root) /opt/open-xchange/imageconverter/lib/com.openexchange.imageconverter.clt.jar
%dir %attr(750, open-xchange, root) /opt/open-xchange/imageconverter/sbin/
%attr(0755,root,root) /opt/open-xchange/imageconverter/sbin/imageconverter-admin
%attr(0755,root,root) /opt/open-xchange/imageconverter/sbin/initfileitemdb
%attr(0755,root,root) /opt/open-xchange/imageconverter/sbin/open-xchange-imageconverter
%dir %attr(750, open-xchange, root) /var/log/open-xchange/imageconverter
%dir %attr(750, open-xchange, root) /var/spool/open-xchange/fileitem
%dir %attr(750, open-xchange, root) /var/spool/open-xchange/imageconverter
/usr/lib/systemd/system/open-xchange-imageconverter-server.service
%doc docs/%{dropin_example}

%changelog
* Thu Feb 03 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-02-07 (6089)
