/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */



package com.openexchange.fileitem.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.json.JSONObject;
import com.openexchange.annotation.NonNull;

/**
 * {@link GroupConfiguration}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 * @since v7.10.3
 */
public class GroupConfiguration {

    /**
     * Unused
     */
    private GroupConfiguration() {
        // Unused
        super();
        m_groupId = null;
    }

    /**
     * Initializes a new {@link GroupConfiguration}.
     */
    public GroupConfiguration(@NonNull final String groupId ) {
        super();
        m_groupId = groupId;
    }

    public String getGroupId() {
        return m_groupId;
    }

    /**
     * getPropertyNames
     *
     * @return
     */
    public Set<String> getKeys() {
        return m_keys;
    }

    /**
     * getPropertyNames
     *
     * @return
     */
    public Set<String> getCustomKeys() {
        return m_customKeys;
    }

    /**
     * isUseCountTable
     *
     * @return
     */
    public boolean isUseCountTable() {
        return m_useCountTable;
    }

    /**
     * setUseCountTable
     *
     * @param useCountTable
     */
    public void setUseCountTable(final boolean useCountTable) {
        m_useCountTable = useCountTable;
    }

    /**
     * getUserData
     *
     * @return
     */
    public JSONObject getUserData() {
        return m_userData;
    }

    /**
     * setUserData
     *
     * @param userData
     */
    public void setUserData(final JSONObject userData) {
        m_userData = userData;
    }

    // - Members -----------------------------------------------------------

    final private String m_groupId;

    final private Set<String> m_keys = Collections.synchronizedSet(new LinkedHashSet<>());

    final private Set<String> m_customKeys = Collections.synchronizedSet(new LinkedHashSet<>());

    volatile private boolean m_useCountTable = false;

    volatile private JSONObject m_userData = new JSONObject();
}
