/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.script;

import java.io.File;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.Properties;
import org.im4java.core.ImageCommand;
import org.im4java.core.Operation;
import org.im4java.script.ScriptGenerator;

public abstract class AbstractScriptGenerator
implements ScriptGenerator {
    protected static final int LINE_SIZE = 78;
    protected char ESC_EOL;
    protected char ESC_SPECIAL;
    protected String iIndent = "";
    protected StringBuilder iLineBuffer = null;
    protected int iArgIndex = 0;
    private Properties iProps = null;
    private PrintWriter iWriter = null;
    private ImageCommand iCmd = null;
    private Operation iOp = null;

    @Override
    public void createScript() {
        this.iIndent = "";
        this.iArgIndex = 0;
        this.writeHeader();
        this.writeCommand();
        this.writeOperation();
        this.getWriter().flush();
    }

    protected void writeHeader() {
    }

    protected String getSearchPath() {
        String string = this.getProperties().getProperty("im4java.globalSearchPath");
        String string2 = this.getProperties().getProperty("im4java.localSearchPath");
        String string3 = null;
        if (string2.length() > 0 && string.length() > 0) {
            string3 = string2 + File.pathSeparator + string;
        } else if (string2.length() > 0 && string.length() == 0) {
            string3 = string2;
        } else if (string.length() > 0) {
            string3 = string;
        }
        return string3;
    }

    protected void writeCommand() {
        PrintWriter printWriter = this.getWriter();
        printWriter.print(this.iProps.getProperty("im4java.cmd"));
        printWriter.println(this.ESC_EOL);
        this.iIndent = this.iIndent + "  ";
    }

    protected String getScriptArg(String string) {
        return null;
    }

    protected String quote(String string) {
        return null;
    }

    protected void writeOperation() {
        LinkedList<String> linkedList = this.getOperation().getCmdArgs();
        this.iLineBuffer = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : linkedList) {
            char c = string.charAt(0);
            if (c == '-' || c == '+') {
                this.flushBuffer(stringBuilder);
                stringBuilder = new StringBuilder(string);
                continue;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            if (string.startsWith("?img?")) {
                stringBuilder.append(this.getScriptArg(string));
                continue;
            }
            if (c == '(') {
                this.flushBuffer(stringBuilder);
                this.flushLine(false);
                stringBuilder = new StringBuilder("\"(\"");
                this.flushBuffer(stringBuilder);
                this.flushLine(false);
                stringBuilder = new StringBuilder();
                this.iIndent = this.iIndent + "  ";
                continue;
            }
            if (c == ')') {
                this.flushBuffer(stringBuilder);
                this.flushLine(false);
                this.iIndent = this.iIndent.substring(0, this.iIndent.length() - 2);
                stringBuilder = new StringBuilder("\")\"");
                this.flushBuffer(stringBuilder);
                this.flushLine(false);
                stringBuilder = new StringBuilder();
                continue;
            }
            stringBuilder.append(this.quote(string));
        }
        this.flushBuffer(stringBuilder);
        this.flushLine(true);
    }

    private void flushBuffer(StringBuilder stringBuilder) {
        if (this.iIndent.length() + this.iLineBuffer.length() + stringBuilder.length() + 2 > 78) {
            this.flushLine(false);
            this.iLineBuffer.append((CharSequence)stringBuilder);
        } else {
            this.iLineBuffer.append((CharSequence)stringBuilder);
            this.iLineBuffer.append(" ");
        }
    }

    private void flushLine(boolean bl) {
        PrintWriter printWriter = this.getWriter();
        printWriter.print(this.iIndent);
        printWriter.print(this.iLineBuffer.toString());
        if (bl) {
            printWriter.println("\n");
        } else {
            printWriter.println(this.ESC_EOL);
            this.iLineBuffer = new StringBuilder();
        }
    }

    @Override
    public void init(PrintWriter printWriter, Operation operation, Properties properties) {
        this.iWriter = printWriter;
        this.iOp = operation;
        this.iProps = properties;
    }

    public PrintWriter getWriter() {
        return this.iWriter;
    }

    public Operation getOperation() {
        return this.iOp;
    }

    public Properties getProperties() {
        return this.iProps;
    }
}

