/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import java.io.IOException;
import org.joda.time.Duration;

public class DurationSerializer
extends JodaDateSerializerBase<Duration> {
    private static final long serialVersionUID = 1L;

    public DurationSerializer() {
        this(FormatConfig.DEFAULT_DATEONLY_FORMAT);
    }

    public DurationSerializer(JacksonJodaDateFormat formatter) {
        super(Duration.class, formatter, false, SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
    }

    public DurationSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new DurationSerializer(formatter);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Duration value) {
        return value.getMillis() == 0L;
    }

    public void serialize(Duration value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._useTimestamp(provider)) {
            gen.writeNumber(value.getMillis());
        } else {
            gen.writeString(value.toString());
        }
    }
}

