/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.imageconverter.impl;

import static com.openexchange.imageconverter.impl.ImageConverterUtils.LOG;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import com.google.common.base.Throwables;
import com.openexchange.imageconverter.api.IImageConverterMonitoring;
import com.openexchange.imageconverter.api.ImageConverterPriority;
import com.openexchange.imageconverter.impl.ImageConverterMonitoring.RequestType;
import com.openexchange.management.AnnotatedStandardMBean;

public class ImageConverterMBean extends AnnotatedStandardMBean implements IImageConverterMonitoring {

    /**
     * Domain
     */
    final public static String DOMAIN = "com.openexchange.imageconverter";

    /**
     * Initializes a new {@link ImageConverterInformation}.
     * @param statistics Musn't be null
     * @throws NotCompliantMBeanException
     */
    public ImageConverterMBean(final ImageConverterMonitoring imageConverterMonitoring) throws NotCompliantMBeanException {
        super("MBean for ImageConverter", IImageConverterMonitoring.class);
        m_imageConverterMonitoring = imageConverterMonitoring;
    }

    /**
     * @return
     */
    public static ObjectName getObjectName() {
        try {
            return new ObjectName(DOMAIN, "name", "ImageConverterMonitoring");
        } catch (MalformedObjectNameException e) {
            LOG.error("IC exeption when creating ObjectName for MBean", Throwables.getRootCause(e));
        }

        return null;
    }

    // - IImageConverterMonitoring ---------------------------------------------

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getCacheHitRatio()
     */
    @Override
    public double getCacheHitRatio() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getCacheHitRatio() : 0.0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getKeysProcessedCount()
     */
    @Override
    public long getKeysProcessedCount() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getKeysProcessedCount() : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getMedianKeyProcessTimeMilliss()
     */
    @Override
    public long getMedianKeyProcessTimeMillis() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getMedianProcessTimeMillis() : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getKeyRequestCount_Total()
     */
    @Override
    public long getRequestCount_Total() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getRequestCount(null) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getKeyRequestCount_Total()
     */
    @Override
    public long getRequestCount_Get() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getRequestCount(RequestType.GET) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getKeyRequestCount_Background()
     */
    @Override
    public long getRequestCount_Cache() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getRequestCount(RequestType.CACHE) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getKeyRequestCount_Medium()
     */
    @Override
    public long getRequestCount_CacheAndGet() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getRequestCount(RequestType.CACHE_AND_GET) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getKeyRequestCount_Instant()
     */
    @Override
    public long getRequestCount_Admin() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getRequestCount(RequestType.ADMIN) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getMedianKeyRequestTimeMillis_Total()
     */
    @Override
    public long getMedianRequestTimeMillis_Total() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getMedianRequestTimeMillis(null) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getMedianKeyRequestTimeMillis_Total()
     */
    @Override
    public long getMedianRequestTimeMillis_Get() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getMedianRequestTimeMillis(RequestType.GET) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getMedianKeyRequestTimeMillis_Background()
     */
    @Override
    public long getMedianRequestTimeMillis_Cache() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getMedianRequestTimeMillis(RequestType.CACHE) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getMedianKeyRequestTimeMillis_Medium()
     */
    @Override
    public long getMedianRequestTimeMillis_CacheAndGet() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getMedianRequestTimeMillis(RequestType.CACHE_AND_GET) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getMedianKeyRequestTimeMillis_Instant()
     */
    @Override
    public long getMedianRequestTimeMillis_Admin() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getMedianRequestTimeMillis(RequestType.ADMIN) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getPeakKeyCountInQueue_Background()
     */
    @Override
    public long getPeakKeyCountInQueue_Background() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getPeakKeyCountInQueue(ImageConverterPriority.BACKGROUND) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getPeakKeyCountInQueue_Medium()
     */
    @Override
    public long getPeakKeyCountInQueue_Medium() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getPeakKeyCountInQueue(ImageConverterPriority.MEDIUM) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getPeakKeyCountInQueue_Instant()
     */
    @Override
    public long getPeakKeyCountInQueue_Instant() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getPeakKeyCountInQueue(ImageConverterPriority.INSTANT) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getMedianKeyQueueTimeMillis_Total()
     */
    @Override
    public long getMedianKeyQueueTimeMillis_Total() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getMedianKeyQueueTimeMillis(null) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getMedianKeyQueueTimeMillis_Background()
     */
    @Override
    public long getMedianKeyQueueTimeMillis_Background() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getMedianKeyQueueTimeMillis(ImageConverterPriority.BACKGROUND) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getMedianKeyQueueTimeMillis_Medium()
     */
    @Override
    public long getMedianKeyQueueTimeMillis_Medium() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getMedianKeyQueueTimeMillis(ImageConverterPriority.MEDIUM) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getMedianKeyQueueTimeMillis_Instant()
     */
    @Override
    public long getMedianKeyQueueTimeMillis_Instant() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getMedianKeyQueueTimeMillis(ImageConverterPriority.INSTANT) : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getCacheKeyCount()
     */
    @Override
    public long getCacheKeyCount() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getCacheKeyCount() : 0;
    }

    /* (non-Javadoc)
     * @see com.openexchange.imageconverter.api.IImageConverterMonitoring#getCacheSize()
     */
    @Override
    public long getCacheSize() {
        return (null != m_imageConverterMonitoring) ? m_imageConverterMonitoring.getCacheSize() : 0;
    }

    // - Members ---------------------------------------------------------------

    private ImageConverterMonitoring m_imageConverterMonitoring;
}
