%define use_systemd (0%{?rhel} && 0%{?rhel} >= 7) || (0%{?suse_version} && 0%{?suse_version} >=1210)

Name:          open-xchange-imageconverter-server
BuildArch:     noarch
%if 0%{?suse_version}
BuildRequires: java-1_8_0-openjdk-devel
%else
BuildRequires: java-1.8.0-openjdk-devel
%endif
%if 0%{?rhel_version} && 0%{?rhel_version} >= 700
BuildRequires: ant
%else
BuildRequires: ant-nodeps
%endif
BuildRequires: open-xchange-core >= 7.10.0
BuildRequires: open-xchange-admin-soap >= 7.10.0
BuildRequires: open-xchange-authentication-database >= 7.10.0
BuildRequires: open-xchange-authorization-standard >= 7.10.0
BuildRequires: open-xchange-file-distribution >= 7.10.0
BuildRequires: open-xchange-grizzly >= 7.10.0
BuildRequires: open-xchange-oauth >= 7.10.0
BuildRequires: open-xchange-oauth-provider >= 7.10.0
BuildRequires: open-xchange-publish >= 7.10.0
BuildRequires: open-xchange-rest >= 7.10.0
BuildRequires: open-xchange-sessionstorage-hazelcast >= 7.10.0
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
BuildRequires:    systemd-rpm-macros
%endif
Version:       7.10.0
%define        ox_release 7
Release:       %{ox_release}_<CI_CNT>.<B_CNT>
Group:         Applications/Productivity
License:       GPL-2.0
BuildRoot:     %{_tmppath}/%{name}-%{version}-build
URL:           http://www.open-xchange.com/
Source:        %{name}_%{version}.orig.tar.bz2
Source1:       open-xchange-imageconverter-server.init
Source2:       open-xchange-imageconverter-server.service
%define        dropin_dir /etc/systemd/system/open-xchange-imageconverter-server.service.d
%define        dropin_example limits.conf
Summary:       The Open-Xchange webservice for image conversion
AutoReqProv:   no
Requires:      gawk
Requires:      curl
Requires:      sed
Requires:      open-xchange-core >= 7.10.0
Requires:      open-xchange-admin-soap >= 7.10.0
Requires:      open-xchange-file-distribution >= 7.10.0
Requires:      open-xchange-grizzly >= 7.10.0
Requires:      open-xchange-rest >= 7.10.0
Provides:      open-xchange-imageconverter-server = %{version}
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
Requires(pre):    systemd
Requires(post):   systemd
Requires(preun):  systemd
Requires(postun): systemd
%endif

%description
This package contains the backend components for the ImageConverter web service

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -lib build/lib -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build
mkdir -p %{buildroot}/var/log/open-xchange/imageconverter
mkdir -p %{buildroot}/var/spool/open-xchange/fileitem
mkdir -p %{buildroot}/var/spool/open-xchange/imageconverter
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
%__install -D -m 444 %{SOURCE2} %{buildroot}/usr/lib/systemd/system/open-xchange-imageconverter-server.service
%else
mkdir -p %{buildroot}/etc/init.d
install -m 755 %{SOURCE1} %{buildroot}/etc/init.d/open-xchange-imageconverter-server
%endif

# On Redhat and SuSE start scripts are not automatically added to system start. This is wanted behavior and standard.

%post
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
%service_add_post open-xchange-imageconverter-server.service
%endif
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700)
if [ ! -f %{dropin_dir}/%{dropin_example} ]
then
  install -D -m 644 %{_defaultdocdir}/%{name}-%{version}/%{dropin_example} %{dropin_dir}/%{dropin_example}
fi
%endif
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
if [ ! -f %{dropin_dir}/%{dropin_example} ]
then
  install -D -m 644 %{_defaultdocdir}/%{name}/%{dropin_example} %{dropin_dir}/%{dropin_example}
fi
%endif

drop_in=%{dropin_dir}/%{dropin_example}
if [ -f ${drop_in} ] && grep -q "^#LimitNOFILE=16384$" ${drop_in}
then
  sed -i 's/^#LimitNOFILE=16384$/#LimitNOFILE=65536/' ${drop_in}
fi

drop_in=%{dropin_dir}/%{dropin_example}
if [ -f ${drop_in} ] && ! grep -q LimitNPROC ${drop_in}
then
  sed -i '/^\[Service\]$/a #LimitNPROC=65536' ${drop_in}
fi

# Trigger a service definition/config reload
%if %{use_systemd}
systemctl daemon-reload &> /dev/null || :
%endif

%preun
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
%service_del_preun open-xchange-imageconverter-server.service
%endif

%postun
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
%service_del_postun open-xchange-imageconverter-server.service
%endif

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/imageconverter
%dir /opt/open-xchange/imageconverter/bundles/
/opt/open-xchange/imageconverter/bundles/*
%dir %attr(750, open-xchange, root) /opt/open-xchange/imageconverter/osgi/
/opt/open-xchange/imageconverter/osgi/config.ini.template
%dir /opt/open-xchange/imageconverter/osgi/bundle.d/
/opt/open-xchange/imageconverter/osgi/bundle.d/*
%dir /opt/open-xchange/imageconverter/etc/
%config(noreplace) /opt/open-xchange/imageconverter/etc/*
%dir %attr(750, open-xchange, root) /opt/open-xchange/imageconverter/sbin/
%attr(0755,root,root) /opt/open-xchange/imageconverter/sbin/open-xchange-imageconverter
%attr(0755,root,root) /opt/open-xchange/imageconverter/sbin/imageconverter-admin
%attr(0755,root,root) /opt/open-xchange/imageconverter/sbin/initfileitemdb
%dir %attr(750, open-xchange, root) /var/log/open-xchange/imageconverter
%dir %attr(750, open-xchange, root) /var/spool/open-xchange/fileitem
%dir %attr(750, open-xchange, root) /var/spool/open-xchange/imageconverter
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
/usr/lib/systemd/system/open-xchange-imageconverter-server.service
%else
/etc/init.d/open-xchange-imageconverter-server
%endif

%if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
%doc docs/%{dropin_example}
%endif

%changelog
* Mon Jun 25 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
Second candidate for 7.10.0 release
* Mon Jun 11 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
First candidate for 7.10.0 release
* Fri May 18 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
Sixth preview of 7.10.0 release
* Thu Apr 19 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
Fifth preview of 7.10.0 release
* Tue Apr 03 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
Third preview of 7.10.0 release
* Tue Feb 20 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
Second preview of 7.10.0 release
* Fri Feb 02 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
First preview of 7.10.0 release
* Mon Oct 23 2017 Kai Ahrens <kai.ahrens@open-xchange.com>
First preview of 7.10.0 release
* Tue Apr 04 2017 Kai Ahrens <kai.ahrens@open-xchange.com>
First preview of 7.8.4 release
