package com.openexchange.imageconverter.client.generated.modules;

import com.openexchange.imageconverter.client.generated.invoker.ApiException;
import com.openexchange.imageconverter.client.generated.invoker.ApiClient;
import com.openexchange.imageconverter.client.generated.invoker.Configuration;
import com.openexchange.imageconverter.client.generated.invoker.Pair;

import javax.ws.rs.core.GenericType;

import java.io.File;
import com.openexchange.imageconverter.client.generated.models.KeyCount;
import com.openexchange.imageconverter.client.generated.models.Keys;
import com.openexchange.imageconverter.client.generated.models.ResponseGeneral;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class ImageConverterApi {
  private ApiClient apiClient;

  public ImageConverterApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ImageConverterApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Creating a new sequence of preview images for a source image under a certain image key, if not available, and/or retrieving the image with the given image key and best matching request format.
   * 
   * @param imageKey The key of the image group. (required)
   * @param requestFormat The image format for which a best matching image is to be returned. (required)
   * @param sourceImage The source image file for which the preview images are to be created. (required)
   * @param context The context of the image group, if specified. (optional, default to )
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File cacheAndGetImage(String imageKey, String requestFormat, File sourceImage, String context) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'imageKey' is set
    if (imageKey == null) {
      throw new ApiException(400, "Missing the required parameter 'imageKey' when calling cacheAndGetImage");
    }
    
    // verify the required parameter 'requestFormat' is set
    if (requestFormat == null) {
      throw new ApiException(400, "Missing the required parameter 'requestFormat' when calling cacheAndGetImage");
    }
    
    // verify the required parameter 'sourceImage' is set
    if (sourceImage == null) {
      throw new ApiException(400, "Missing the required parameter 'sourceImage' when calling cacheAndGetImage");
    }
    
    // create path and map variables
    String localVarPath = "/cacheAndGetImage/{imageKey}/{requestFormat}"
      .replaceAll("\\{" + "imageKey" + "\\}", apiClient.escapeString(imageKey.toString()))
      .replaceAll("\\{" + "requestFormat" + "\\}", apiClient.escapeString(requestFormat.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "context", context));

    
    if (sourceImage != null)
      localVarFormParams.put("sourceImage", sourceImage);

    final String[] localVarAccepts = {
      "multipart/form-data"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "multipart/form-data"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<File> localVarReturnType = new GenericType<File>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Creating a new sequence of preview images for a source image under a certain image key, if not available, and/or retrieving the image with the given image key and best matching request format as image/_* MultipartEntity as well as the image metadata as application/json Multipart entity within the Multipart/form-data response
   * 
   * @param imageKey The key of the image group. (required)
   * @param requestFormat The image format for which a best matching image is to be returned. (required)
   * @param sourceImage The source image file for which the preview images are to be created. (required)
   * @param context The context of the image group, if specified. (optional, default to )
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File cacheAndGetImageAndMetadata(String imageKey, String requestFormat, File sourceImage, String context) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'imageKey' is set
    if (imageKey == null) {
      throw new ApiException(400, "Missing the required parameter 'imageKey' when calling cacheAndGetImageAndMetadata");
    }
    
    // verify the required parameter 'requestFormat' is set
    if (requestFormat == null) {
      throw new ApiException(400, "Missing the required parameter 'requestFormat' when calling cacheAndGetImageAndMetadata");
    }
    
    // verify the required parameter 'sourceImage' is set
    if (sourceImage == null) {
      throw new ApiException(400, "Missing the required parameter 'sourceImage' when calling cacheAndGetImageAndMetadata");
    }
    
    // create path and map variables
    String localVarPath = "/cacheAndGetImageAndMetadata/{imageKey}/{requestFormat}"
      .replaceAll("\\{" + "imageKey" + "\\}", apiClient.escapeString(imageKey.toString()))
      .replaceAll("\\{" + "requestFormat" + "\\}", apiClient.escapeString(requestFormat.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "context", context));

    
    if (sourceImage != null)
      localVarFormParams.put("sourceImage", sourceImage);

    final String[] localVarAccepts = {
      "multipart/form-data"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "multipart/form-data"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<File> localVarReturnType = new GenericType<File>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Creating a new sequence of preview images for a source image under a certain image key.
   * 
   * @param imageKey The key of the image group. (required)
   * @param sourceImage The source image file for which the preview images are to be created. (required)
   * @param context The context of the image group, if specified. (optional, default to )
   * @return ResponseGeneral
   * @throws ApiException if fails to make API call
   */
  public ResponseGeneral cacheImage(String imageKey, File sourceImage, String context) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'imageKey' is set
    if (imageKey == null) {
      throw new ApiException(400, "Missing the required parameter 'imageKey' when calling cacheImage");
    }
    
    // verify the required parameter 'sourceImage' is set
    if (sourceImage == null) {
      throw new ApiException(400, "Missing the required parameter 'sourceImage' when calling cacheImage");
    }
    
    // create path and map variables
    String localVarPath = "/cacheImage/{imageKey}"
      .replaceAll("\\{" + "imageKey" + "\\}", apiClient.escapeString(imageKey.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "context", context));

    
    if (sourceImage != null)
      localVarFormParams.put("sourceImage", sourceImage);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "multipart/form-data"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ResponseGeneral> localVarReturnType = new GenericType<ResponseGeneral>() {};
    return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Removing all images from the Image Server. This call leaves an Image Server with no images left after a succesful request!
   * 
   * @param context The context of the image group, if specified. (optional, default to )
   * @return ResponseGeneral
   * @throws ApiException if fails to make API call
   */
  public ResponseGeneral clearImages(String context) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/clearImages";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "context", context));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ResponseGeneral> localVarReturnType = new GenericType<ResponseGeneral>() {};
    return apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Removing all images matching the specified key from the Image Server.
   * 
   * @param imageKey The key of the image group. (required)
   * @return ResponseGeneral
   * @throws ApiException if fails to make API call
   */
  public ResponseGeneral clearImagesByKey(String imageKey) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'imageKey' is set
    if (imageKey == null) {
      throw new ApiException(400, "Missing the required parameter 'imageKey' when calling clearImagesByKey");
    }
    
    // create path and map variables
    String localVarPath = "/clearImagesByKey/{imageKey}"
      .replaceAll("\\{" + "imageKey" + "\\}", apiClient.escapeString(imageKey.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<ResponseGeneral> localVarReturnType = new GenericType<ResponseGeneral>() {};
    return apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Retrieving the image with the given image key and best matching request format.
   * 
   * @param imageKey The key of the image group. (required)
   * @param requestFormat The image format for which a best matching image is to be returned. (required)
   * @param context The context of the image group, if specified. (optional, default to )
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getImage(String imageKey, String requestFormat, String context) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'imageKey' is set
    if (imageKey == null) {
      throw new ApiException(400, "Missing the required parameter 'imageKey' when calling getImage");
    }
    
    // verify the required parameter 'requestFormat' is set
    if (requestFormat == null) {
      throw new ApiException(400, "Missing the required parameter 'requestFormat' when calling getImage");
    }
    
    // create path and map variables
    String localVarPath = "/getImage/{imageKey}/{requestFormat}"
      .replaceAll("\\{" + "imageKey" + "\\}", apiClient.escapeString(imageKey.toString()))
      .replaceAll("\\{" + "requestFormat" + "\\}", apiClient.escapeString(requestFormat.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "context", context));

    
    
    final String[] localVarAccepts = {
      "multipart/form-data"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<File> localVarReturnType = new GenericType<File>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Retrieving the image with the given image key and best matching request format as image/_* MultipartEntity as well as the image metadata as application/json Multipart entity within the mMultipart/form-data response
   * 
   * @param imageKey The key of the image group. (required)
   * @param requestFormat The image format for which a best matching image is to be returned. (required)
   * @param context The context of the image group, if specified. (optional, default to )
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getImageAndMetadata(String imageKey, String requestFormat, String context) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'imageKey' is set
    if (imageKey == null) {
      throw new ApiException(400, "Missing the required parameter 'imageKey' when calling getImageAndMetadata");
    }
    
    // verify the required parameter 'requestFormat' is set
    if (requestFormat == null) {
      throw new ApiException(400, "Missing the required parameter 'requestFormat' when calling getImageAndMetadata");
    }
    
    // create path and map variables
    String localVarPath = "/getImageAndMetadata/{imageKey}/{requestFormat}"
      .replaceAll("\\{" + "imageKey" + "\\}", apiClient.escapeString(imageKey.toString()))
      .replaceAll("\\{" + "requestFormat" + "\\}", apiClient.escapeString(requestFormat.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "context", context));

    
    
    final String[] localVarAccepts = {
      "multipart/form-data"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<File> localVarReturnType = new GenericType<File>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Retrieving either the number of all keys or the number of keys that match the given context from the Image Server.
   * 
   * @param context The context of the image group, if specified. (optional, default to )
   * @return KeyCount
   * @throws ApiException if fails to make API call
   */
  public KeyCount getKeyCount(String context) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/getKeyCount";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "context", context));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<KeyCount> localVarReturnType = new GenericType<KeyCount>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Retrieving either all keys or the keys that match the given context from the Image Server.
   * 
   * @param context The context of the image group, if specified. (optional, default to )
   * @return Keys
   * @throws ApiException if fails to make API call
   */
  public Keys getKeys(String context) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/getKeys";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "context", context));

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<Keys> localVarReturnType = new GenericType<Keys>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Retrieving the image metadata with the given image key.
   * 
   * @param imageKey The key of the image group. (required)
   * @param context The context of the image group, if specified. (optional, default to )
   * @return File
   * @throws ApiException if fails to make API call
   */
  public File getMetadata(String imageKey, String context) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'imageKey' is set
    if (imageKey == null) {
      throw new ApiException(400, "Missing the required parameter 'imageKey' when calling getMetadata");
    }
    
    // create path and map variables
    String localVarPath = "/getMetadata/{imageKey}"
      .replaceAll("\\{" + "imageKey" + "\\}", apiClient.escapeString(imageKey.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "context", context));

    
    
    final String[] localVarAccepts = {
      "multipart/form-data"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<File> localVarReturnType = new GenericType<File>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Getting the current status of the Image Server as text/html response.
   * 
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String status() throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/status";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "text/html"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] {  };

    GenericType<String> localVarReturnType = new GenericType<String>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
