/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.oxapi.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.fileupload.util.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;

/**
 * Processes a JSON stream
 */
public class JsonStreamHandler implements StreamHandler {

    private final JsonObject additionalObject;
    private final String additionalObjectName;

    /**
     * Constructor
     */
    public JsonStreamHandler(){
        this.additionalObject = null;
        this.additionalObjectName = null;
    }

    /**
     * Constructor
     * @param additionalObjectName The name of the JSON object to add to the streams' JSON
     * @param additionalObject The JSON object to add to the stream's JSON
     */
    public JsonStreamHandler(String additionalObjectName,
                             JsonObject additionalObject) {
        this.additionalObject = additionalObject;
        this.additionalObjectName = additionalObjectName;
    }

    @Override
    public void processStream(InputStream inputStream,
        OutputStream outputStream,
        int suggestedBufferSize) throws IOException {

        //Reading the JSON from the input stream and
        Gson gson = new GsonBuilder().create();
        String jsonString = Streams.asString(inputStream);
        JsonObject json = gson.fromJson(jsonString, JsonObject.class);

        //Adding additional object to the JSON
        if (additionalObject != null &&
            additionalObjectName != null) {
            json.add(additionalObjectName, additionalObject);
        }

        //Writing the JSON to the output stream
        outputStream.write(
            json.toString().getBytes(Charset.defaultCharset()));
    }

    @Override
    public String getNewContentType(String oldContentType, String fileName) {
        return oldContentType;
    }

    @Override
    public String getNewName(String oldName) {
        return oldName;
    }

}
;