package com.openexchange.guard.mime.encryptor.osgi;

import org.slf4j.Logger;
import com.openexchange.guard.cipher.GuardCipherFactoryService;
import com.openexchange.guard.configuration.GuardConfigurationService;
import com.openexchange.guard.encryption.EncryptedItemsStorage;
import com.openexchange.guard.keymanagement.services.AccountCreationService;
import com.openexchange.guard.keymanagement.services.GuardKeyService;
import com.openexchange.guard.keymanagement.services.GuardMasterKeyService;
import com.openexchange.guard.keymanagement.services.RecipKeyService;
import com.openexchange.guard.mailcreator.MailCreatorService;
import com.openexchange.guard.mime.encryptor.PGPMimeEncryptionService;
import com.openexchange.guard.mime.services.MimeEncryptionService;
import com.openexchange.guard.notification.GuardNotificationService;
import com.openexchange.guard.pgpcore.services.PGPCryptoService;
import com.openexchange.guard.storage.Storage;
import com.openexchange.guard.translation.GuardTranslationService;
import com.openexchange.guard.user.GuardUserService;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.pgp.mail.PGPMimeService;

public class MimeEncryptor extends HousekeepingActivator {

    /**
     * {@inheritDoc}
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] { GuardConfigurationService.class, GuardTranslationService.class, MailCreatorService.class,
            GuardNotificationService.class, GuardMasterKeyService.class, GuardCipherFactoryService.class, GuardKeyService.class,
            GuardUserService.class, EncryptedItemsStorage.class, RecipKeyService.class, PGPCryptoService.class, Storage.class,
            AccountCreationService.class, PGPMimeService.class };
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void startBundle() throws Exception {
        Logger logger = org.slf4j.LoggerFactory.getLogger(MimeEncryptor.class);
        logger.info("Starting bundle: {}", context.getBundle().getSymbolicName());

        Services.setServiceLookup(this);
        registerService(MimeEncryptionService.class,
            new PGPMimeEncryptionService(getService(PGPCryptoService.class),
            getService(PGPMimeService.class),
            getService(GuardConfigurationService.class)));
        logger.info("MimeEncryptor registered.");

        openTrackers();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void stopBundle() throws Exception {
        Logger logger = org.slf4j.LoggerFactory.getLogger(MimeEncryptor.class);
        logger.info("Stopping bundle: {}", this.context.getBundle().getSymbolicName());
        unregisterService(MimeEncryptor.class);
        logger.info("MimeEncryptor unregistered.");

        Services.setServiceLookup(null);

        super.stopBundle();
    }

}
