define([
    'io.ox/core/extensions',
    'spec/shared/capabilities',
    'mailvelope/sync/syncobject'
],function (ext, caputil, sync) {

    var capabilities = caputil.preset('common').init([], []);

    describe('Mailvelope synchronization', function () {
        beforeEach(function () {
            window.mailvelope = {};
            window.mailvelope.getKeyring = function (id) {
                return $.when({
                    id: id
                });
            };

            require.undef('mailvelope/main');
            return capabilities.enable(['mailvelope']).then(function () {
                return require(['mailvelope/main']);
            });
        });
        var point = ext.point('oxguard/mailvelope/sync');

        describe('default implementation', function () {
            it('should have extension for "oxguard/mailvelope/sync"', function (done) {
                expect(point.has('default')).to.be.true;
                point.get('default', function (p) {
                    expect(p).to.exist;
                    expect(p.index).to.equal('last');
                    done();
                });
            });
        });

        describe('custom implementations', function () {
            //do not run in PhantomJS, since it does not provide Promise API
            if (_.device('PhantomJS')) return;

            function doSync(method) {
                var api = require('mailvelope/main');
                sync.addHandler({
                    addSyncHandler: function (obj) {
                        api.handlers = obj;
                        var p = new window.Promise(function (resolve) {
                            resolve();
                        });
                        return p;
                    }
                });
                api.handlers[method]();
            }

            it('should register extensions uploadSync method', function () {
                var spy = sinon.spy();

                //extend sync point
                point.extend({
                    id: 'custom',
                    uploadSync: spy
                });

                doSync('uploadSync');
                expect(spy.called, 'uploadSync called').to.be.true;

                point.disable('custom');
                doSync('uploadSync');
                expect(spy.calledOnce, 'uploadSync called once').to.be.true;
            });

            it('should register with any Mailvelope syncObject API method', function () {
                var spy = sinon.spy();

                //extend sync point
                point.extend({
                    id: 'custom2',
                    uploadSync: spy,
                    downloadSync: spy,
                    backup: spy,
                    restore: spy
                });

                doSync('uploadSync');
                expect(spy.callCount).to.equal(1);
                doSync('downloadSync');
                expect(spy.callCount).to.equal(2);
                doSync('backup');
                expect(spy.callCount).to.equal(3);
                doSync('restore');
                expect(spy.callCount).to.equal(4);

                point.disable('custom2');
            });
        });
    });
});
